<?php

namespace App\Http\Integrations\GetOnlinetrader\Requests\Signal;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetSignalSubscribers extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    public function __construct(protected readonly string $page)
    {
    }
    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return '/signal-subscribers';
    }

    protected function defaultQuery(): array
    {
        return ['page' => $this->page];
    }
}
