<?php

namespace App\Livewire\Admin\Membership;

use App\Models\Settings;
use App\Services\MembershipService;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.admin')]
class Categories extends Component
{
    use LivewireAlert;

    public $categories;
    public $addNew = false;
    public $categoryName;

    // Load categories on mount
    public function mount(MembershipService $membership): void
    {
        $settings = Settings::select('modules')->find(1);
        abort_if($settings->modules['membership'] !== 'true', 404);

        // Fetch categories
        try {
            $this->categories = $membership->categories();
        } catch (\Exception $e) {
            $this->alert('error', $e->getMessage());
        }
    }

    // Render the component
    public function render()
    {
        return view('livewire.admin.membership.categories');
    }

    // Save new category
    public function save(MembershipService $membership): void
    {
        // Validate input
        $this->validate(['categoryName' => ['required']]);

        try {
            $message = $membership->saveCategory($this->categoryName);
            $this->categoryName = '';
            $this->addNew = false;

            // Refresh categories after saving
            $this->categories = $membership->categories();
            $this->alert('success', $message);
        } catch (\Exception $e) {
            $this->alert('error', $e->getMessage());
        }
    }

    // Delete category
    public function delete(MembershipService $membership, int $id): void
    {
        try {
            $message = $membership->deleteCategory($id);

            // Refresh categories after deletion
            $this->categories = $membership->categories();
            $this->alert('success', $message);
        } catch (\Exception $e) {
            $this->alert('error', $e->getMessage());
        }
    }
}
