<?php

namespace App\Livewire\Admin\Membership;

use App\Models\Settings;
use App\Services\MembershipService;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.admin')]
class CourseLessons extends Component
{
    public int $id;  // Course ID
    public int $page;  // Pagination page
    public $nextPageUrl;
    public $previousPageUrl;
    public $lessons;
    public $course;

    // Initialize component
    public function mount(int $id, int $page): void
    {
        // Check if membership module is enabled
        $settings = Settings::select('modules')->find(1);
        abort_if($settings->modules['membership'] !== 'true', 404);

        $this->id = $id;
        $this->page = $page;
    }

    // Render lessons
    public function render(MembershipService $mem)
    {
        try {
            // Fetch course lessons using updated service
            $data = $mem->courseLessons($this->id, $this->page);
            $this->course = $mem->course($this->id); // Fetch course details

            // Handle pagination
            $this->nextPageUrl = $data['next_page_url'] ?? null;
            $this->previousPageUrl = $data['prev_page_url'] ?? null;

            // Load lessons data
            $this->lessons = $data['data'] ?? [];
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }

        // Render the view
        return view('livewire.admin.membership.course-lessons');
    }

    // Refresh lessons data
    public function refreshLessons(MembershipService $mem)
    {
        try {
            $data = $mem->courseLessons($this->id, $this->page);
            $this->lessons = $data['data'] ?? [];
            $this->nextPageUrl = $data['next_page_url'] ?? null;
            $this->previousPageUrl = $data['prev_page_url'] ?? null;
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }
    }
}
