<?php

namespace App\Livewire\Admin\Settings;

use App\Models\Settings;
use Illuminate\Support\Facades\Cache;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Spatie\Permission\Models\Role;

#[Layout('layouts.admin')]
class ModulesSettings extends Component
{
    use LivewireAlert;

    public $set;
    public $modules;
    public $permissions = [];
    public $role;

    public function mount(): void
    {
        $role = Role::firstWhere('name', 'User');
        $this->permissions = $role->permissions->pluck('name');
        $this->role = $role;

        $settings = Settings::select([
            'id',
            'modules',
        ])->find(1);
        $this->fill($settings);
        $this->set = $settings;
    }

    public function render()
    {
        return view('livewire.admin.settings.modules-settings');
    }

    public function updateModule($module, $value): void
    {
    $settings = Settings::find(1);
    $options = $settings->modules;
    $options[$module] = $value === 'true' ? true : false;
    
    try {
        $settings->modules = $options;
        $settings->save();
        Cache::forget('site_settings');
        activity()->log('Module ' . $module . ' Updated');
        $this->alert('success', 'Module Updated Successfully');
    } catch (\Exception $e) {
        $this->alert('error', 'Failed to update module');
    }
    }

    public function savePermissions(): void
    {
        $this->role->syncPermissions($this->permissions);
        $this->alert(message: 'Settings Saved Successfully');
    }
}
