<?php
namespace App\Livewire\User\Membership;

use App\Exceptions\MembershipException;
use App\Models\Settings;
use App\Services\MembershipService;
use Livewire\Component;

class MyCourseDetails extends Component
{
    public $data;

    public function mount(MembershipService $membership, string $id)
    {
        $settings = Settings::select('modules')->find(1);
        
        // More robust check for membership module status
        $isMembershipEnabled = $settings 
            && is_array($settings->modules) 
            && ($settings->modules['membership'] === 'true' || $settings->modules['membership'] === true);
        
        if (!$isMembershipEnabled) {
            session()->flash('message', 'Membership module is currently disabled.');
            return redirect()->route('user.dashboard');
        }

        try {
            $this->data = $membership->course($id);
        } catch (MembershipException $e) {
            session()->flash('message', $e->getMessage());
            return redirect()->route('user.dashboard');
        } catch (\Throwable $e) {
            session()->flash('message', 'An unexpected error occurred while fetching course details.');
            return redirect()->route('user.dashboard');
        }
    }

    public function render()
    {
        $template = Settings::select('theme')->find(1)->theme ?? 'default';
        return view("{$template}.membership.my-course-details")
            ->extends("layouts.{$template}")
            ->title('Course Details');
    }
}