<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CopiedTrade extends Model
{
    protected $fillable = [
        'copy_trade_id',
        'original_trade_id',
        'copied_trade_id',
        'amount',
        'profit_amount',
        'status',
        'result',
        'error_message'
    ];

    protected $casts = [
        'amount' => 'decimal:8',
        'profit_amount' => 'decimal:8'
    ];

    // Relationships
    public function copyTrade(): BelongsTo
    {
        return $this->belongsTo(CopyTrade::class);
    }

    public function originalTrade(): BelongsTo
    {
        return $this->belongsTo(Trade::class, 'original_trade_id');
    }

    public function copiedTrade(): BelongsTo
    {
        return $this->belongsTo(Trade::class, 'copied_trade_id');
    }
}