<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SignalSubscription extends Model
{
    protected $fillable = [
        'user_id',
        'signal_id',
        'subscribed_at',
        'expired_at',
        'status',
        'telegram_user_id',
        'amount_paid',
        'duration'
    ];

    protected $dates = [
        'expired_at'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function signal(): BelongsTo
    {
        return $this->belongsTo(Signal::class);
    }
}