<?php

namespace App\Providers;

use App\Models\TradingAccount;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $isProduction = $this->app->environment('production');

        Schema::defaultStringLength(191);

        Model::shouldBeStrict(! $isProduction);

        // Auto-create storage link for non-technical users
        $this->createStorageLinkIfNeeded();

        // authorization
        Gate::define('renew-account', function (
            User $user,
            TradingAccount $account
        ) {
            return $user->id === $account->user_id;
        });
    }

    /**
     * Automatically create storage link if it doesn't exist
     * This helps non-technical users when hosting on cPanel
     */
    private function createStorageLinkIfNeeded(): void
    {
        $publicStoragePath = public_path('storage');
        $storageAppPublicPath = storage_path('app/public');

        // Only create if the link doesn't exist or is broken
        if (!file_exists($publicStoragePath) || !is_link($publicStoragePath)) {
            try {
                // Remove broken link if exists
                if (file_exists($publicStoragePath)) {
                    unlink($publicStoragePath);
                }
                
                // Create the symbolic link
                if (function_exists('symlink')) {
                    symlink($storageAppPublicPath, $publicStoragePath);
                } else {
                    // Fallback for Windows or restricted servers
                    \Illuminate\Support\Facades\Artisan::call('storage:link');
                }
            } catch (\Exception $e) {
                // Silently fail - log if needed
                \Illuminate\Support\Facades\Log::info('Storage link creation failed: ' . $e->getMessage());
            }
        }
    }
}
