<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('crypto_assets', function (Blueprint $table) {
            $table->id();
            $table->string('symbol')->unique(); // BTC, ETH, etc.
            $table->string('name'); // Bitcoin, Ethereum
            $table->string('coingecko_id')->unique(); // bitcoin, ethereum
            $table->string('logo_url')->nullable();
            $table->decimal('current_price', 20, 8)->default(0);
            $table->decimal('price_change_24h', 20, 8)->default(0);
            $table->decimal('price_change_percentage_24h', 10, 4)->default(0);
            $table->decimal('market_cap', 20, 2)->default(0);
            $table->decimal('total_volume', 20, 2)->default(0);
            $table->decimal('high_24h', 20, 8)->default(0);
            $table->decimal('low_24h', 20, 8)->default(0);
            $table->integer('market_cap_rank')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamp('last_updated')->nullable();
            $table->timestamps();
            
            $table->index(['symbol', 'is_active']);
            $table->index('market_cap_rank');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('crypto_assets');
    }
};
