<x-app-layout>
<x-slot name="title">
        Annual Reports
    </x-slot>
    <!-- Index Page -->
<div class="col-12">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Annual Reports</h5>
            <a href="{{ route('admin.annual-reports.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add New Report
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Year</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reports as $report)
                            <tr>
                                <td>{{ $report->name }}</td>
                                <td>{{ $report->report_year }}</td>
                                <td>
                                    <span class="badge {{ $report->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $report->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ Storage::url($report->file_path) }}" 
                                           target="_blank"
                                           class="btn btn-sm btn-info"
                                           data-bs-toggle="tooltip"
                                           title="View PDF">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <form action="{{ route('admin.annual-reports.toggle', $report) }}" 
                                              method="POST" 
                                              class="d-inline">
                                            @csrf
                                            <button type="submit" 
                                                    class="btn btn-sm btn-warning"
                                                    data-bs-toggle="tooltip"
                                                    title="{{ $report->is_active ? 'Deactivate' : 'Activate' }}">
                                                <i class="fas fa-toggle-{{ $report->is_active ? 'on' : 'off' }}"></i>
                                            </button>
                                        </form>

                                        <form action="{{ route('admin.annual-reports.destroy', $report) }}" 
                                              method="POST" 
                                              class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="btn btn-sm btn-danger"
                                                    data-bs-toggle="tooltip"
                                                    title="Delete"
                                                    onclick="return confirm('Are you sure you want to delete this report?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center">No annual reports found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</x-app-layout>
<!-- Add this to the header for tooltips initialization -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>




