<x-app-layout>
<x-slot name="title">
        Pending Trades
    </x-slot>
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <h4 class="card-title">Pending Trades</h4>
                </div>
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible fade show">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Pair</th>
                                    <th>Amount</th>
                                    <th>Type</th>
                                    <th>Entry Price</th>
                                    <th>Duration</th>
                                    <th>Expected Result</th>
                                    <th>Profit Amount</th>
                                    <th>Started At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($trades as $trade)
                                    <tr>
                                        <td>{{ $trade->user->name }}</td>
                                        <td>{{ $trade->pair }}</td>
                                        <td>{{ number_format($trade->amount, 2) }}</td>
                                        <td>
                                            <span class="badge bg-{{ $trade->type == 'Rise' ? 'success' : 'danger' }}">
                                                {{ $trade->type }}
                                            </span>
                                        </td>
                                        <td>{{ $trade->entry_price }}</td>
                                        <td>{{ $trade->duration }}</td>
                                        <td>
                                            <span class="badge bg-{{ $trade->expected_result == 'win' ? 'success' : 'danger' }}">
                                                {{ ucfirst($trade->expected_result) }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="text-{{ $trade->profit_amount >= 0 ? 'success' : 'danger' }}">
                                                {{ number_format($trade->profit_amount, 2) }}
                                            </span>
                                        </td>
                                        <td>{{ $trade->created_at->format('d M, Y H:i') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" 
                                                        class="btn btn-sm btn-info" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#tradeModal-{{ $trade->id }}">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <button type="button" 
                                                        class="btn btn-sm btn-primary" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#editModal-{{ $trade->id }}">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editModal-{{ $trade->id }}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('admin.trading.update', $trade) }}" method="POST">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Edit Trade Result</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="expected_result" class="form-label">Expected Result</label>
                                                            <select name="expected_result" id="expected_result" class="form-select">
                                                                <option value="win" {{ $trade->expected_result == 'win' ? 'selected' : '' }}>Win</option>
                                                                <option value="loss" {{ $trade->expected_result == 'loss' ? 'selected' : '' }}>Loss</option>
                                                            </select>
                                                            @error('expected_result')
                                                                <span class="text-danger small">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="profit_amount" class="form-label">Profit Amount</label>
                                                            <div class="input-group">
                                                                <input type="number" 
                                                                       name="profit_amount" 
                                                                       id="profit_amount" 
                                                                       class="form-control" 
                                                                       value="{{ abs($trade->profit_amount) }}"
                                                                       step="0.01"
                                                                       min="0">
                                                            </div>
                                                            <small class="text-muted">
                                                                Current: 
                                                                <span class="text-{{ $trade->profit_amount >= 0 ? 'success' : 'danger' }}">
                                                                    {{ number_format($trade->profit_amount, 2) }}
                                                                </span>
                                                            </small>
                                                            @error('profit_amount')
                                                                <span class="text-danger small">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- View Details Modal -->
                                    <div class="modal fade" id="tradeModal-{{ $trade->id }}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Trade Details</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>User:</strong></div>
                                                        <div class="col-6">{{ $trade->user->name }}</div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Pair:</strong></div>
                                                        <div class="col-6">{{ $trade->pair }}</div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Amount:</strong></div>
                                                        <div class="col-6">{{ number_format($trade->amount, 2) }}</div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Type:</strong></div>
                                                        <div class="col-6">
                                                            <span class="badge bg-{{ $trade->type == 'Rise' ? 'success' : 'danger' }}">
                                                                {{ $trade->type }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Entry Price:</strong></div>
                                                        <div class="col-6">{{ $trade->entry_price }}</div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Duration:</strong></div>
                                                        <div class="col-6">{{ $trade->duration }}</div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Expected Result:</strong></div>
                                                        <div class="col-6">
                                                            <span class="badge bg-{{ $trade->expected_result == 'win' ? 'success' : 'danger' }}">
                                                                {{ ucfirst($trade->expected_result) }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Profit Amount:</strong></div>
                                                        <div class="col-6">
                                                            <span class="text-{{ $trade->profit_amount >= 0 ? 'success' : 'danger' }}">
                                                                {{ number_format($trade->profit_amount, 2) }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">No pending trades found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        {{ $trades->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
                    <script>
document.addEventListener('DOMContentLoaded', function() {
    // Get all edit buttons
    const editButtons = document.querySelectorAll('[data-bs-toggle="modal"]');
    
    editButtons.forEach(button => {
        button.addEventListener('click', () => {
            const modalId = button.getAttribute('data-bs-target');
            const modal = document.querySelector(modalId);
            if (modal) {
                modal.style.display = 'block';
                modal.classList.add('show');
                document.body.classList.add('modal-open');
                
                // Add backdrop
                const backdrop = document.createElement('div');
                backdrop.className = 'modal-backdrop fade show';
                document.body.appendChild(backdrop);
            }
        });
    });

    // Handle close buttons
    const closeButtons = document.querySelectorAll('[data-bs-dismiss="modal"]');
    closeButtons.forEach(button => {
        button.addEventListener('click', () => {
            const modal = button.closest('.modal');
            if (modal) {
                modal.style.display = 'none';
                modal.classList.remove('show');
                document.body.classList.remove('modal-open');
                
                // Remove backdrop
                const backdrop = document.querySelector('.modal-backdrop');
                if (backdrop) {
                    backdrop.remove();
                }
            }
        });
    });
});
</script>
<style>
.modal {
    background-color: rgba(0,0,0,0.5);
}
.modal.show {
    display: block;
}
</style>
</x-app-layout>




