<x-guest-layout>
    <x-slot:title>{{ __('forgot_password') }}</x-slot:title>

    <div class="min-h-screen flex items-center justify-center">
        <div class="w-full max-w-md">
            {{-- Mobile Logo --}}
            <div class="lg:hidden flex flex-col items-center gap-4 mb-8">
                @if(isset($settings) && $settings->logo)
                    <img 
                        alt="Logo" 
                        src="{{ asset($settings->logo) }}"
                        class="w-[250px] h-auto animate-float" 
                    />
                @endif
                <div class="flex items-center gap-2 text-sm">
                    <div class="w-2 h-2 rounded-full bg-[#F0B90B] animate-pulse"></div>
                    <span class="text-gray-400">{{ __('t.trading_platform') }}</span>
                </div>
            </div>

            <x-language-switcher />

            <div class="bg-theme-secondary rounded-2xl p-4">
                {{-- Header Section --}}
                <div class="text-center mb-8">
                    <div class="bg-[#F0B90B]/10 w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="key" class="w-8 h-8 text-[#F0B90B]"></i>
                    </div>
                    <h1 class="text-2xl font-medium mb-2">{{ __('t.forgot_password_question') }}</h1>
                    <p class="text-gray-400">{{ __('t.forgot_password_instructions') }}</p>
                </div>

                {{-- Success Message --}}
                @if (session('status'))
                    <div class="bg-[#F0B90B]/10 text-[#F0B90B] p-4 rounded-xl mb-6 flex items-center gap-3">
                        <i data-lucide="check-circle" class="w-5 h-5 flex-shrink-0"></i>
                        <p>{{ __('t.reset_link_sent') }}</p>
                    </div>
                @endif

                <form method="POST" action="{{ route('password.email') }}" class="space-y-6">
                    @csrf
                    {{-- Email Input --}}
                    <div>
                        <label class="text-sm text-gray-400 block mb-2">{{ __('t.email_address') }}</label>
                        <div class="relative">
                            <div class="absolute left-4 top-1/2 -translate-y-1/2">
                                <i data-lucide="mail" class="w-5 h-5 text-gray-400"></i>
                            </div>
                            <x-form.input 
                                type="email"
                                name="email"
                                placeholder="{{ __('t.email_placeholder') }}"
                                required
                                autofocus
                                class="w-full bg-theme-tertiary border-2 border-theme-quaternary rounded-xl pl-12 pr-4 py-3 text-gray-100 focus:outline-none focus:border-[#F0B90B]" />
                        </div>
                        {{-- Validation Error --}}
                        @error('email')
                            <small class="text-xs text-danger fs-6">{{ $message }}</small>
                        @enderror
                    </div>

                    {{-- Action Buttons --}}
                    <div class="flex flex-col sm:flex-row gap-4">
                        <button type="submit"
                            class="flex-1 bg-gradient-to-r from-[#F0B90B] to-[#F0B90B]/80 text-black font-medium px-6 py-3 rounded-xl hover:brightness-110 transition-colors flex items-center justify-center gap-3">
                            <span class="indicator-label flex items-center gap-2">
                                <i data-lucide="send" class="w-5 h-5"></i>
                                {{ __('t.submit_button') }}
                            </span>
                            <span class="indicator-progress hidden">
                                <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                            </span>
                        </button>
                        <a href="{{ url('/login') }}"
                            class="flex-1 bg-theme-tertiary text-gray-300 font-medium px-6 py-3 rounded-xl hover:bg-theme-quaternary transition-colors flex items-center justify-center gap-2">
                            <i data-lucide="arrow-left" class="w-5 h-5"></i>
                            {{ __('t.cancel_button') }}
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-guest-layout>





