@props([
    'name' => '',
    'readOnly' => false,
    'required' => false,
    'rows' => 3,
    'errors' => [],
    'placeholder' => ''
])

<textarea 
    name="{{ $name }}" 
    rows="{{ $rows }}" 
    placeholder="{{ $placeholder }}"
    {{ $attributes->merge(['class' => 'form-control']) }}
    @readonly($readOnly) 
    @required($required)
>{{ $slot }}</textarea>
<div>
    @error($name)
        <small class="text-xs text-danger fs-6">{{ $message }}</small>
    @enderror
</div>





