<aside class="hidden md:flex flex-col w-72 bg-theme-secondary border-r border-gray-800/50 min-h-screen overflow-y-auto">
    {{-- User Profile Section --}}
    <div class="p-6 border-b border-gray-800/50">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 rounded-xl bg-theme-tertiary flex-shrink-0 overflow-hidden">
                <img 
                    src="{{ auth()->user()->profile_photo_path ? asset('storage/' . auth()->user()->profile_photo_path) : asset('dash/images/avatar.svg') }}"
                    alt="{{ auth()->user()->name }}"
                    class="w-full h-full object-cover">
            </div>
            <div class="flex-1 min-w-0">
                <h3 class="font-medium truncate">{{ auth()->user()->name }}</h3>
                <p class="text-sm text-gray-400 truncate">{{ auth()->user()->email }}</p>
            </div>
        </div>
    </div>

    {{-- Navigation Menu --}}
    <div class="p-4 flex-1">
        <nav class="space-y-1">
            {{-- Main Navigation Group --}}
            <div class="space-y-1 mb-6">
                {{-- Dashboard --}}
                <a href="{{ route('user.dashboard') }}" 
                    @if($settings->spa_mode) wire:navigate @endif
                    @class([
                        'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                        'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.dashboard'),
                        'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.dashboard')
                    ])>
                    <i class="fas fa-th-large w-5 h-5"></i>
                   <span>{{ __('t.dash') }}</span>
                </a>

                {{-- Trading & Markets Group --}}
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Trading</p>

                    {{-- Live Trading --}}
                    <a href="{{ route('user.trading.overview') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.trading.*'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.trading.*')
                        ])>
                        <i class="fas fa-chart-candlestick w-5 h-5"></i>
                        <span>Live Trading</span>
                    </a>

                    {{-- Crypto Swap --}}
                    @if($mod['cryptoswap'] == 'true')
                    <div x-data="{ open: {{ request()->routeIs('user.swap.*') ? 'true' : 'false' }} }">
                        <button @click="open = !open" 
                         class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                        :class="{'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary': open, 'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-repeat w-5 h-5"></i>
                                <span>Crypto Swap</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            class="pl-12 mt-1 space-y-1">
                            <a href="{{ route('user.swap.assets') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-theme-primary' => request()->routeIs('user.swap.assets'),
                                    'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.swap.assets')
                                ])>
                                Market Assets
                            </a>
                            <a href="{{ route('user.swap.transactions') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-theme-primary' => request()->routeIs('user.swap.transactions'),
                                    'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.swap.transactions')
                                ])>
                                Swap History
                            </a>
                        </div>
                    </div>
                    @endif

                    {{-- Copy Trading --}}
                    @if($settings->use_copytrade)
                    <a href="{{ route('user.copier.show') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.copier.*'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.copier.*')
                        ])>
                        <i class="fas fa-copy w-5 h-5"></i>
                        <span>Copy Trading</span>
                    </a>
                    @endif

                    {{-- Trade Signals --}}
                  
                </div>

                {{-- Investment Plans Group --}}
                @if($mod['investment'] == 'true')
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Investment</p>
                    
                    <div x-data="{ open: {{ request()->routeIs('user.investment.*') ? 'true' : 'false' }} }">
                        <button @click="open = !open" 
                            class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                            :class="{'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary': open, 'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-chart-line w-5 h-5"></i>
                                <span>Investment Plans</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            class="pl-12 mt-1 space-y-1">
                            @can('purchase plan')
                            <a href="{{ route('user.investment.buyplan') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-theme-primary' => request()->routeIs('user.investment.buyplan'),
                                    'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.investment.buyplan')
                                ])>
                                Browse Plans
                            </a>
                            @endcan
                            @can('see their plans')
                            <a href="{{ route('user.investment.myplans') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-theme-primary' => request()->routeIs('user.investment.myplans'),
                                    'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.investment.myplans')
                                ])>
                                My Investments
                            </a>
                            @endcan
                        </div>
                    </div>
                </div>
                @endif

                {{-- Wallet & Funds Management --}}
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Wallet</p>
                    
                    @can('make deposit')
                    <a href="{{ route('user.deposit.make') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.deposit.*'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.deposit.*')
                        ])>
                        <i class="fas fa-wallet w-5 h-5"></i>
                        <span>Deposit Funds</span>
                    </a>
                    @endcan

                    @can('make withdrawal')
                    <a href="{{ route('user.withdraw.request') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.withdraw.request'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.withdraw.request')
                        ])>
                        <i class="fas fa-money-bill-transfer w-5 h-5"></i>
                        <span>Withdraw Funds</span>
                    </a>
                    @endcan

                    @if($settings->use_transfer)
                    <a href="{{ route('user.transferfund') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.transferfund'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.transferfund')
                        ])>
                        <i class="fas fa-exchange-alt w-5 h-5"></i>
                        <span>Transfer Funds</span>
                    </a>
                    @endif

                    @can('see their transactions history')
                    <a href="{{ route('user.transactions.deposit') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.transactions.*'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.transactions.*')
                        ])>
                        <i class="fas fa-receipt w-5 h-5"></i>
                        <span>Transaction History</span>
                    </a>
                    @endcan
                </div>

                {{-- Education & Resources --}}
                @if($mod['membership'] == 'true')
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Education</p>
                    
                    <div x-data="{ open: {{ request()->routeIs('user.membership.*') ? 'true' : 'false' }} }">
                        <button @click="open = !open" 
                        class="flex items-center justify-between w-full px-4 py-2.5 rounded-xl transition-all"
                        :class="{'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary': open, 'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100': !open}">
                            <div class="flex items-center gap-3">
                                <i class="fas fa-graduation-cap w-5 h-5"></i>
                                <span>Learning Center</span>
                            </div>
                            <i class="fas fa-chevron-down w-4 h-4 transition-transform" :class="open ? 'rotate-180' : ''"></i>
                        </button>
                        <div x-show="open" 
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            class="pl-12 mt-1 space-y-1">
                            <a href="{{ route('user.membership.courses', ['page' => '1']) }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-theme-primary' => request()->routeIs('user.membership.courses'),
                                    'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.membership.courses')
                                ])>
                                All Courses
                            </a>
                            <a href="{{ route('user.membership.mycourses') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                @class([
                                    'flex items-center gap-3 px-4 py-2 rounded-xl transition-all', 
                                    'text-theme-primary' => request()->routeIs('user.membership.mycourses'),
                                    'text-gray-400 hover:text-gray-100' => !request()->routeIs('user.membership.mycourses')
                                ])>
                                My Courses
                            </a>
                        </div>
                    </div>
                </div>
                @endif

                {{-- Account & Support --}}
                <div class="mt-6">
                    <p class="px-4 py-2 text-xs font-medium text-gray-400 uppercase mb-2">Account</p>

                    @can('refer users')
                    <a href="{{ route('user.referral') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.referral'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.referral')
                        ])>
                        <i class="fas fa-users w-5 h-5"></i>
                        <span>Referral Program</span>
                    </a>
                    @endcan

                    <a href="{{ route('user.notifications') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.notifications'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.notifications')
                        ])>
                        <i class="fas fa-bell w-5 h-5"></i>
                       <span>Notifications</span>
                    </a>

                    @can('contact support')
                    <a href="{{ route('user.contactsupport') }}" 
                        @if($settings->spa_mode) wire:navigate @endif
                        @class([
                            'flex items-center gap-3 px-4 py-2.5 rounded-xl transition-all', 
                            'bg-gradient-to-r from-theme-primary/10 to-transparent text-theme-primary' => request()->routeIs('user.contactsupport'),
                            'text-gray-400 hover:bg-theme-tertiary hover:text-gray-100' => !request()->routeIs('user.contactsupport')
                        ])>
                        <i class="fas fa-headset w-5 h-5"></i>
                       <span>Support Center</span>
                    </a>
                    @endcan
                </div>
            </div>
             {{-- Promotional Card & Logout --}}
    <div class="p-4 border-t border-gray-800/50">
        {{-- Promo Card --}}
        <div class="bg-gradient-to-br from-theme-primary/20 to-transparent p-4 rounded-xl mb-4">
            <h4 class="font-medium text-theme-primary mb-2">Start Trading Today</h4>
            <p class="text-sm text-gray-400 mb-3">Access global markets and grow your portfolio</p>
            <a href="{{ route('user.trading.overview') }}" 
                @if($settings->spa_mode) wire:navigate @endif
                class="block w-full bg-gradient-to-r from-theme-primary to-theme-primary/80 text-white text-sm font-medium py-2 px-4 rounded-lg hover:brightness-110 transition-all text-center">
                Trade Now
            </a>
        </div>

        {{-- Logout Button --}}
        <form action="{{ route('logout') }}" method="POST">
            @csrf
            <button type="submit" 
                class="w-full flex items-center justify-center gap-2 px-4 py-2.5 rounded-xl text-gray-400 hover:bg-theme-tertiary hover:text-gray-100 transition-all">
                <i class="fas fa-sign-out-alt w-5 h-5"></i>
                <span>Sign Out</span>
            </button>
        </form>
    </div>
        </nav>
    </div>
</aside>





