<div class="relative" x-data="{ open: false }">
    <button 
        id="languageDropdown"
        class="flex items-center gap-2 px-3 py-2 hover:bg-gray-800/50 rounded-lg transition-colors"
        @click="open = !open">
        <span>{{ get_locale_name() }}</span>
        <i data-lucide="chevron-down" class="w-4 h-4"></i>
    </button>

    <div 
        id="languageMenu"
        x-show="open"
        @click.outside="open = false"
        class="absolute right-0 mt-2 bg-gray-800 rounded-lg shadow-lg overflow-hidden z-50"
        style="display: none;">
        @foreach(get_available_locales() as $locale => $name)
            <a 
                href="{{ route('language.switch', $locale) }}"
                class="block px-4 py-2 hover:bg-gray-700 {{ app()->getLocale() === $locale ? 'bg-gray-700' : '' }}">
                {{ $name }}
            </a>
        @endforeach
    </div>
</div>





