<div class="space-y-6 mb-5 md:mb-1">
    {{-- Breadcrumb 
    <div class="pl-3 pt-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-theme-primary transition-colors">{{ __('t.dash') }}</a>
        <i class="fas fa-chevron-right w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.support') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    {{-- Main Grid --}}
    <div class="grid lg:grid-cols-3 gap-6">
        {{-- Contact Form Section --}}
        <div class="lg:col-span-2">
            <div class="bg-theme-secondary rounded-2xl">
                <div class="p-6 border-b border-gray-800/50">
                    <h2 class="text-lg font-medium">{{ __('t.contact_support') }}</h2>
                </div>

                <div class="p-6">
                    <form wire:submit='send' class="space-y-6">
                        {{-- Subject Input --}}
                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">{{ __('t.subject') }}</label>
                            <div class="relative">
                                <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                                    <i class="fas fa-heading"></i>
                                </div>
                                <input 
                                    type="text" 
                                    wire:model='subject'
                                    class="w-full bg-theme-tertiary border border-gray-800 rounded-xl pl-10 pr-4 py-3 focus:outline-none focus:border-theme-primary transition-colors"
                                    placeholder="{{ __('t.enter_subject') }}"
                                    required
                                >
                            </div>
                        </div>

                        {{-- Message Input --}}
                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">{{ __('t.message') }}</label>
                            <div class="relative">
                                <textarea 
                                    wire:model='message'
                                    rows="6"
                                    class="w-full bg-theme-tertiary border border-gray-800 rounded-xl px-4 py-3 focus:outline-none focus:border-theme-primary transition-colors"
                                    placeholder="{{ __('t.enter_message') }}"
                                    required
                                ></textarea>
                            </div>
                        </div>

                        {{-- Submit Button --}}
                        <button 
                            type="submit"
                            class="w-full bg-gradient-theme-primary text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-3 disabled:opacity-50"
                            wire:loading.attr="disabled">
                            <div wire:loading wire:target="send">
                                <i class="fas fa-spinner fa-spin"></i>
                            </div>
                            <i class="fas fa-paper-plane" wire:loading.remove wire:target="send"></i>
                            <span wire:loading.remove wire:target="send">{{ __('t.send_message') }}</span>
                            <span wire:loading wire:target="send">{{ __('t.sending') }}</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>

        {{-- Support Info Section --}}
        <div class="lg:col-span-1">
            <div class="bg-theme-secondary rounded-2xl">
                <div class="p-6 border-b border-gray-800/50">
                    <h3 class="text-lg font-medium">{{ __('t.contact_info') }}</h3>
                </div>

                <div class="p-6 space-y-6">
                    {{-- Email Contact --}}
                    <div class="bg-theme-tertiary rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-theme-primary/10 rounded-lg flex-shrink-0">
                                <i class="fas fa-envelope text-theme-primary"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">{{ __('t.email_support') }}</h4>
                                <a href="mailto:{{ $settings->contact_email }}" 
                                    class="text-theme-primary hover:brightness-110 transition-all">
                                    {{ $settings->contact_email }}
                                </a>
                            </div>
                        </div>
                    </div>

                    {{-- Support Hours --}}
                    <div class="bg-theme-tertiary rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-theme-primary/10 rounded-lg flex-shrink-0">
                                <i class="fas fa-clock text-theme-primary"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">{{ __('t.support_hours') }}</h4>
                                <p class="text-sm text-gray-400">{{ __('t.support_available') }}</p>
                            </div>
                        </div>
                    </div>

                    {{-- Response Time --}}
                    <div class="bg-theme-tertiary rounded-xl p-4">
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 flex items-center justify-center bg-theme-primary/10 rounded-lg flex-shrink-0">
                                <i class="fas fa-history text-theme-primary"></i>
                            </div>
                            <div>
                                <h4 class="font-medium mb-1">{{ __('t.response_time') }}</h4>
                                <p class="text-sm text-gray-400">{{ __('t.typical_response') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



