<div class="space-y-6" x-data="{ compact: true }">
    {{-- Breadcrumbs --}}
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">Dashboard</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">Copytrade</span>
    </div>

    <x-danger-alert />
    <x-success-alert />

    {{-- View Toggle --}}
    @if(!$settings->use_copytrade)
        <div class="flex justify-end">
            <button 
                x-text="compact ? 'Compact View' : 'Full View'" 
                x-on:click="compact=!compact"
                class="bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
            </button>
        </div>
    @endif

    <div class="grid gap-6" :class="compact ? 'lg:grid-cols-[1fr]' : 'lg:grid-cols-1'">
        <div>
            {{-- Account Manager Info --}}
            <div class="bg-theme-secondary rounded-xl p-6 space-y-4 mb-6" x-show="compact">
                <h3 class="text-xl font-medium">Advanced {{ $settings->site_name }} Account manager</h3>
                <div class="space-y-4 text-gray-300">
                    <p>Don't have time to trade or learn how to trade?</p>
                    <p>Our Account Management Service is The Best Profitable Trading Option for you, We can help you to manage your account in the financial MARKET with a simple accountscription model.</p>
                    <p class="text-sm text-gray-400">Terms and Conditions apply</p>
                    <p>Reach us at {{ $settings->contact_email }} for more info.</p>
                </div>
            </div>

            {{-- Accounts Table --}}
            <div class="bg-theme-secondary rounded-xl p-6">
                <div class="flex flex-col lg:flex-row justify-between gap-4 mb-6">
                    <h4 class="text-lg font-medium">My Accounts</h4>
                    <div class="flex gap-3">
                        @if($settings->use_copytrade)
                            <a href="{{ route('user.copier.masters') }}" 
                                @if($settings->spa_mode) wire:navigate @endif
                                class="inline-flex items-center gap-2 bg-red-400/10 text-red-400 px-4 py-2 rounded-lg hover:bg-red-400/20 transition-colors">
                                <i data-lucide="users" class="w-4 h-4"></i>
                                View Providers
                            </a>
                        @endif
                        @if($settings->ib_link)
                            <a href="{{ $settings->ib_link }}" 
                                target="_blank"
                                class="inline-flex items-center gap-2 bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                                <i data-lucide="plus" class="w-4 h-4"></i>
                                Create Account
                            </a>
                        @endif
                    </div>
                </div>

                @if($accounts->count() === 0)
                    <div class="text-center py-12 space-y-4">
                        <div class="w-16 h-16 bg-gray-800/50 rounded-full flex items-center justify-center mx-auto">
                            <i data-lucide="layout-grid" class="w-8 h-8 text-gray-400"></i>
                        </div>
                        <h6 class="text-lg font-medium">You have no managed accounts</h6>
                        <a href="{{ route('user.copier.masters') }}" 
                            @if($settings->spa_mode) wire:navigate @endif
                            class="inline-flex items-center gap-2 bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                            <i data-lucide="users" class="w-4 h-4"></i>
                            View Providers
                        </a>
                    </div>
                @else
                    <div class="relative overflow-x-auto">
                        <table class="w-full">
                            <thead>
                                <tr class="text-left text-sm text-gray-400 border-b border-gray-800">
                                    <th class="pb-3 font-medium">Account</th>
                                    <th class="pb-3 font-medium">Currency</th>
                                    <th class="pb-3 font-medium">Leverage</th>
                                    <th class="pb-3 font-medium">Server</th>
                                    <th class="pb-3 font-medium">Duration</th>
                                    <th class="pb-3 font-medium">Status</th>
                                    <th class="pb-3 font-medium">Submitted at</th>
                                    <th class="pb-3 font-medium">Start/End date</th>
                                    <th class="pb-3 font-medium">Provider</th>
                                    <th class="pb-3 font-medium"></th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-800">
                                @foreach($accounts as $account)
                                    <tr class="hover:bg-gray-800/50 transition-colors">
                                        <td class="py-4">
                                            <div class="space-y-1">
                                                <p>{{ $account->login }}</p>
                                                <p class="text-sm text-gray-400">{{ $account->account_type }}</p>
                                            </div>
                                        </td>
                                        <td class="py-4">{{ $account->currency }}</td>
                                        <td class="py-4">{{ $account->leverage }}</td>
                                        <td class="py-4">{{ $account->server }}</td>
                                        <td class="py-4">{{ $account->duration }}</td>
                                        <td class="py-4">
                                            <span @class([
                                                'px-2 py-1 text-xs rounded-full',
                                                'bg-yellow-400/10 text-yellow-400' => $account->status == 'pending',
                                                'bg-red-400/10 text-red-400' => $account->status == 'expired',
                                                'bg-theme-primary text-theme-primary' => $account->status == 'processed',
                                            ])>
                                                {{ Str::ucfirst($account->status) }}
                                            </span>
                                        </td>
                                        <td class="py-4">{{ $account->created_at->format('M d Y') }}</td>
                                        <td class="py-4">
                                            {{ !empty($account->start_date) ? $account->start_date->format('M d Y') : '-' }}
                                            /
                                            {{ !empty($account->end_date) ? $account->end_date->format('M d Y') : '-' }}
                                        </td>
                                        <td class="py-4">{{ $account->provider }}</td>
                                        <td class="py-4">
                                            @php
                                                $endAt = $account->end_date;
                                                $remindAt = $account->reminded_at;
                                            @endphp

                                            <div class="flex gap-2">
                                                @if($settings->use_copytrade && $account->status == 'pending')
                                                    <a href="{{ route('user.copier.account.info', ['account' => $account]) }}"
                                                        @if($settings->spa_mode) wire:navigate @endif
                                                        class="inline-flex items-center gap-2 bg-blue-400/10 text-blue-400 px-3 py-1.5 rounded-lg hover:bg-blue-400/20 transition-colors">
                                                        <i data-lucide="info" class="w-4 h-4"></i>
                                                        Info
                                                    </a>
                                                @endif

                                                @if(($account->status != 'pending' && now()->isSameDay($remindAt)) || $account->status == 'expired')
                                                    <button 
                                                        wire:loading.attr='disabled'
                                                        wire:confirm='Are you sure you want to renew this account'
                                                        wire:click.prevent="renew('{{ $account->id }}')"
                                                        class="inline-flex items-center gap-2 bg-theme-primary text-black px-3 py-1.5 rounded-lg hover:bg-theme-primary-dark transition-colors">
                                                        <div wire:loading wire:target="renew('{{ $account->id }}')">
                                                            <i data-lucide="loader-2" class="w-4 h-4 animate-spin"></i>
                                                        </div>
                                                        <span>Renew</span>
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

        {{-- Add Account Form --}}
        @if(!$settings->use_copytrade)
            <div x-show="compact">
                <div class="bg-theme-secondary rounded-xl p-6">
                    <h4 class="text-lg font-medium mb-6">Add new account</h4>
                    
                    <form wire:submit='addAccount' class="space-y-6">
                        <div class="grid md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Duration</label>
                                <select wire:model.live="duration" 
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                                    <option>Monthly</option>
                                    <option>Quarterly</option>
                                    <option>Yearly</option>
                                </select>
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Amount({{ $settings->currency }})</label>
                                <input type="text" wire:model="amount" readonly
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 text-gray-400">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Platform</label>
                                <select wire:model="platform"
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                                    <option>MT4</option>
                                    <option>MT5</option>
                                </select>
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Login</label>
                                <input type="text" wire:model="login" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Account Password</label>
                                <input type="password" wire:model="password" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Account Name</label>
                                <input type="text" wire:model="name" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Account Type</label>
                                <input type="text" wire:model="account_type" placeholder="E.g. Standard" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Currency</label>
                                <input type="text" wire:model="currency" placeholder="E.g. USD" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Leverage</label>
                                <input type="text" wire:model="leverage" placeholder="E.g. 1:500" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>

                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">Server</label>
                                <input type="text" wire:model="server" placeholder="E.g. HantecGlobal-live" required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                        </div>

                        <p class="text-sm text-gray-400">Amount will be deducted from your account balance.</p>

                        <button type="submit"
                            class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
                            <div wire:loading wire:target="addAccount">
                                <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                            </div>
                            <span>Add account</span>
                        </button>
                    </form>
                </div>
            </div>
        @endif
    </div>
</div>

<script>
    lucide.createIcons();
</script>



