<div class="space-y-6 mt-2">
    {{-- Breadcrumbs 
    <div class="pl-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dashboard') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.swap.assets') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.as') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ $coin->name }} {{ __('t.details') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    {{-- Coin Header --}}
    <div class="bg-theme-secondary rounded-xl p-6">
        <div class="flex justify-between items-center">
            <div class="flex items-center gap-4">
                <img src="{{ $coin->logo_url }}" 
                    width="{{ $coin->logo_size }}" 
                    class="rounded-full">
                <div>
                    <h3 class="font-medium text-xl">{{ $coin->name }} ({{ $coin->symbol }})</h3>
                    <p class="text-theme-primary text-lg">${{ $coin->price_in_usd }}</p>
                </div>
            </div>
            <a href="{{ route('user.swap.convert', ['coin' => $coin]) }}"
                @if($settings->spa_mode) wire:navigate @endif
                class="inline-flex items-center gap-2 bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                <span>{{ __('t.convert') }}</span>
                <i data-lucide="arrow-right" class="w-4 h-4"></i>
            </a>
        </div>
    </div>

    {{-- Trading Chart --}}
    <div class="bg-theme-secondary rounded-xl overflow-hidden md:h-[620px] h-[400px]">
        <div id="tradingview_f933e" class="md:h-[600px] h-[400px]"></div>
    </div>
</div>

<script>
    // Initialize Lucide icons
    lucide.createIcons();

    // Initialize TradingView widget
    new TradingView.widget({
        "autosize": true,
        "symbol": "COINBASE:{{ $coin->symbol }}USD",
        "interval": "1",
        "timezone": "Etc/UTC",
        "theme": "dark",
        "style": "1",
        "locale": "en",
        "toolbar_bg": "var(--color-background-secondary)",
        "enable_publishing": false,
        "hide_side_toolbar": false,
        "allow_symbol_change": true,
        "container_id": "tradingview_f933e",
        "save_image": false,
        "backgroundColor": "var(--color-background-secondary)",
        "gridColor": "#233339"
    });
</script>



