<div class="p-6" x-data="{
    copied: false,
    address: '{{ $method->wallet_address }}',
    copyToClipboard(text) {
        if (!navigator.clipboard) {
            return alert('{{ __('t.copy_error') }}')
        }
        navigator.clipboard.writeText(text)
            .then(() => {
                this.copied = true
                setTimeout(() => {
                    this.copied = false
                }, 3000)
            })
    },
}">
    @if ($settings->deposit_option == 'manual')
        <div class="space-y-8">
            {{-- Manual Payment Section --}}
            <div class="space-y-6">
                {{-- Barcode Display --}}
                @if (!empty($method->barcode))
                    <div class="flex flex-col items-center p-6 bg-gray-800/30 rounded-xl">
                        <div class="bg-white p-4 rounded-lg mb-4">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data={{ $method->wallet_address }}" 
                                alt="Payment Barcode" 
                                class="w-48 h-48 object-contain">
                        </div>
                        <p class="text-sm text-gray-400">{{ __('t.scan_qr') }}</p>
                    </div>
                @endif

                {{-- Wallet Address Section --}}
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-400">{{ __('t.deposit_address') }}</span>
                        @if ($method->network)
                            <span class="text-xs px-2 py-1 bg-gray-800/50 rounded-full text-gray-400">
                                {{ __('t.network_label') }}: {{ $method->network }}
                            </span>
                        @endif
                    </div>
                    
                    <div class="flex">
                        <input type="text" 
                            value="{{ $method->wallet_address }}" 
                            readonly 
                            class="flex-1 bg-gray-800/50 border border-r-0 border-gray-700 rounded-l-lg px-4 py-3 text-gray-300 font-mono text-sm"
                        >
                        <button 
                            x-on:click="copyToClipboard(address)"
                            class="px-4 border rounded-r-lg transition-colors group"
                            :class="copied ? 'bg-green-500/10 border-green-500/20 text-green-500' : 'border-gray-700 text-gray-400 hover:text-theme-primary hover:border-theme-primary'"
                        >
                            <i class="fas fa-copy w-5 h-5" x-show="!copied"></i>
                            <i class="fas fa-check w-5 h-5" x-show="copied" style="display: none"></i>
                        </button>
                    </div>
                </div>
            </div>

            {{-- Submit Payment Form --}}
            @include('millage.deposit.includes.submit-payment')
        </div>
    @endif

    @if ($settings->deposit_option != 'manual')
        <div class="space-y-8">
            {{-- Auto Payment Options --}}
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                {{-- Binance Payment --}}
                @if ($method->name == 'USDT' && $settings->auto_merchant_option == 'Binance' && $settings->deposit_option == 'auto')
                    <button type="button" 
                        wire:click='payViaBinance'
                        wire:loading.attr="disabled"
                        class="flex items-center justify-center gap-3 bg-gradient-to-r from-[#F0B90B] to-[#F0B90B]/80 text-black px-6 py-4 rounded-xl hover:brightness-110 transition-all">
                        <img src="https://seeklogo.com/images/B/binance-coin-bnb-logo-CD94CC6D31-seeklogo.com.png"
                            wire:loading.remove 
                            wire:target="payViaBinance" 
                            alt="Binance" 
                            class="w-6 h-6"
                        >
                        <div wire:loading wire:target="payViaBinance">
                            <i class="fas fa-spinner fa-spin w-6 h-6"></i>
                        </div>
                        <span class="font-medium">{{ __('t.pay_with_binance') }}</span>
                    </button>
                @else
                    {{-- Coinbase Payment --}}
                    @if ($settings->auto_deposit_merchant == 'Coinbase')
                        <button type="button" 
                            wire:click='payViaCoinbase'
                            wire:loading.attr="disabled"
                            class="flex items-center justify-center gap-3 bg-gradient-to-r from-[#0052FF] to-[#0052FF]/80 text-white px-6 py-4 rounded-xl hover:brightness-110 transition-all">
                            <img src="https://prod-coin360-cms.s3.eu-central-1.amazonaws.com/coinbase_logo_c429441c37.png"
                                wire:loading.remove 
                                wire:target="payViaCoinbase"
                                alt="Coinbase"
                                class="w-6 h-6"
                            >
                            <div wire:loading wire:target="payViaCoinbase">
                                <i class="fas fa-spinner fa-spin w-6 h-6"></i>
                            </div>
                            <span class="font-medium">{{ __('t.pay_with_coinbase') }}</span>
                        </button>
                    @endif
                @endif
            </div>
        </div>
    @endif
</div>



