<div class="space-y-6 mt-2">
    {{-- Breadcrumbs --}}
    <div class="pl-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dashboard') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.submit_kyc') }}</span>
    </div>

    <x-danger-alert />
    <x-success-alert />

    <div class="max-w-4xl mx-auto">
        <div class="bg-theme-secondary rounded-xl">
            <div class="p-6 space-y-8">
                {{-- Header --}}
                <div class="text-center space-y-2">
                    <h2 class="text-xl font-medium">{{ __('t.begin_id_verification') }}</h2>
                    <div class="text-sm text-gray-400">
                        <p>{{ __('t.fill_form_personal_details') }}</p>
                        <p>{{ __('t.cannot_edit_details') }}</p>
                    </div>
                </div>

                <form wire:submit.prevent='submit' class="space-y-8">
                    {{-- Personal Details --}}
                    <div class="space-y-6">
                        <div>
                            <h5 class="font-medium">{{ __('t.personal_details') }}</h5>
                            <p class="text-sm text-gray-400">{{ __('t.personal_info_identification') }}</p>
                        </div>

                        <div class="grid md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.first_name') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='first_name' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.last_name') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='last_name' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.email') }} <span class="text-red-400">*</span></label>
                                <input type="email" wire:model='email' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.phone_number') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='phone_number' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.date_of_birth') }} <span class="text-red-400">*</span></label>
                                <input type="date" wire:model='dob' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.social_media_username') }}</label>
                                <input type="text" wire:model='social_media'
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                        </div>
                    </div>

                    {{-- Address Details --}}
                    <div class="pt-6 border-t border-gray-800 space-y-6">
                        <div>
                            <h5 class="font-medium">{{ __('t.your_address') }}</h5>
                            <p class="text-sm text-gray-400">{{ __('t.address_info_identification') }}</p>
                        </div>

                        <div class="grid md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.address_line') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='address' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.city') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='city' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.state') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='state' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                            <div class="space-y-2">
                                <label class="text-sm text-gray-400">{{ __('t.nationality') }} <span class="text-red-400">*</span></label>
                                <input type="text" wire:model='country' required
                                    class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                            </div>
                        </div>
                    </div>

                    {{-- Document Upload --}}
                    <div class="pt-6 border-t border-gray-800 space-y-6">
                        <div>
                            <h5 class="font-medium">{{ __('t.document_upload') }}</h5>
                            <p class="text-sm text-gray-400">{{ __('t.document_info_identification') }}</p>
                        </div>

                        <div class="flex flex-wrap gap-4">
                            <label class="relative flex items-center">
                                <input type="radio" wire:model="document_type" value="Int'l Passport" class="peer sr-only">
                                <div class="px-4 py-2 bg-gray-800/50 border border-gray-700 rounded-lg peer-checked:border-[#1D4ED8] peer-checked:text-theme-primary cursor-pointer">
                                    {{ __('t.intl_passport') }}
                                </div>
                            </label>
                            <label class="relative flex items-center">
                                <input type="radio" wire:model="document_type" value="National ID" class="peer sr-only">
                                <div class="px-4 py-2 bg-gray-800/50 border border-gray-700 rounded-lg peer-checked:border-[#1D4ED8] peer-checked:text-theme-primary cursor-pointer">
                                    {{ __('t.national_id') }}
                                </div>
                            </label>
                            <label class="relative flex items-center">
                                <input type="radio" wire:model="document_type" value="Drivers License" class="peer sr-only">
                                <div class="px-4 py-2 bg-gray-800/50 border border-gray-700 rounded-lg peer-checked:border-[#1D4ED8] peer-checked:text-theme-primary cursor-pointer">
                                    {{ __('t.drivers_license') }}
                                </div>
                            </label>
                        </div>

                        <div class="bg-gray-800/50 rounded-lg p-4 space-y-3">
                            <h6 class="font-medium">{{ __('t.document_criteria_heading') }}</h6>
                            <ul class="space-y-2 text-sm text-gray-300">
                                <li class="flex items-center gap-2">
                                    <i data-lucide="check-square" class="w-4 h-4 text-theme-primary"></i>
                                    {{ __('t.document_criteria_1') }}
                                </li>
                                <li class="flex items-center gap-2">
                                    <i data-lucide="check-square" class="w-4 h-4 text-theme-primary"></i>
                                    {{ __('t.document_criteria_2') }}
                                </li>
                                <li class="flex items-center gap-2">
                                    <i data-lucide="check-square" class="w-4 h-4 text-theme-primary"></i>
                                    {{ __('t.document_criteria_3') }}
                                </li>
                            </ul>
                        </div>

                        {{-- Front Image Upload --}}
                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">{{ __('t.upload_front_side') }} <span class="text-red-400">*</span></label>
                            <div class="flex items-center gap-8">
                                <div class="flex-grow">
                                    <input type="file" wire:model.live='frontImg' required
                                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                                    <p class="mt-1 text-xs text-gray-400">{{ __('t.upload_size_info') }}</p>
                                </div>
                                <div class="text-gray-400">
                                    <i data-lucide="id-card" class="w-16 h-16"></i>
                                </div>
                            </div>
                        </div>

                        {{-- Back Image Upload --}}
                        <div class="space-y-2">
                            <label class="text-sm text-gray-400">{{ __('t.upload_back_side') }} <span class="text-red-400">*</span></label>
                            <div class="flex items-center gap-8">
                                <div class="flex-grow">
                                    <input type="file" wire:model.live='backImg' required
                                        class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
                                    <p class="mt-1 text-xs text-gray-400">{{ __('t.upload_size_info') }}</p>
                                </div>
                                <div class="text-gray-400">
                                    <i data-lucide="credit-card" class="w-16 h-16"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Agreement and Buttons --}}
                    <div class="pt-6 border-t border-gray-800 space-y-6">
                        <label class="flex items-center gap-2">
                            <input type="checkbox" required class="w-4 h-4 rounded border-gray-700 bg-gray-800/50 text-theme-primary focus:ring-theme-primary">
                            <span class="text-sm text-gray-300">{{ __('t.agree_information_correct') }}</span>
                        </label>

                        <div class="flex items-center gap-4">
                            <button type="submit" 
                                class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
                                <div wire:loading wire:target="submit">
                                    <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                                </div>
                                <span>{{ __('t.submit_application') }}</span>
                            </button>
                            <a href="{{ route('user.kyc.start') }}"
                                @if($settings->spa_mode) wire:navigate @endif 
                                class="px-6 py-2.5 rounded-lg border border-gray-700 text-gray-300 hover:text-gray-100 transition-colors">
                                {{ __('t.cancel_application') }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



