<div class="space-y-6 mt-2">
    {{-- Breadcrumbs --}}
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dashboard') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.kyc_application') }}</span>
    </div>

    <x-danger-alert />
    <x-success-alert />

    <div class="max-w-3xl mx-auto">
        <div class="bg-theme-secondary rounded-xl">
            <div class="p-6 space-y-8">
                {{-- KYC Header --}}
                <div class="text-center space-y-3">
                    <h2 class="text-xl font-medium">{{ __('t.kyc_verification') }}</h2>
                    <p class="text-gray-400">{{ __('t.kyc_verification_description') }}</p>
                </div>

                {{-- KYC Status --}}
                <div class="bg-gray-800/50 rounded-xl p-8 text-center space-y-4">
                    <div class="inline-flex items-center justify-center w-16 h-16 bg-gray-800 rounded-full">
                        <i data-lucide="file-check" class="w-8 h-8 text-gray-400"></i>
                    </div>
                    <p class="text-gray-300">{{ __('t.kyc_not_submitted') }}</p>

                    @if(Auth::user()->account_verify == 'verified' or Auth::user()->account_verify == 'under review')
                        <div class="space-y-2">
                            <button disabled class="bg-theme-primary text-white px-6 py-2 rounded-lg cursor-not-allowed">
                                {{ __('t.complete_kyc_button') }}
                            </button>
                            <p class="text-sm text-theme-primary">{{ __('t.kyc_under_review_message') }}</p>
                        </div>
                    @else
                        <a href="{{ route('user.kyc.form') }}" 
                            @if($settings->spa_mode) wire:navigate @endif
                            class="inline-block bg-theme-primary text-black px-6 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                            {{ __('t.complete_kyc_button') }}
                        </a>
                    @endif
                </div>

                {{-- Support Section --}}
                @can('contact support')
                    <div class="bg-gray-800/50 rounded-xl p-6">
                        <div class="flex flex-col md:flex-row items-center gap-6">
                            <div class="w-12 h-12 flex items-center justify-center bg-gray-800 rounded-full flex-shrink-0">
                                <i data-lucide="mail-question" class="w-6 h-6 text-gray-400"></i>
                            </div>
                            <div class="flex-grow text-center md:text-left">
                                <h4 class="font-medium mb-2">{{ __('t.support_heading') }}</h4>
                                <p class="text-gray-400">{{ __('t.support_description') }}</p>
                            </div>
                            <div class="flex-shrink-0">
                                <a href="{{ route('user.contactsupport') }}" 
                                    @if($settings->spa_mode) wire:navigate @endif
                                    class="inline-flex items-center gap-2 bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                                    <i data-lucide="help-circle" class="w-4 h-4"></i>
                                    {{ __('t.get_support_button') }}
                                </a>
                            </div>
                        </div>
                    </div>
                @endcan
            </div>
        </div>
    </div>
</div>



