<div class="space-y-6 mt-2">
    {{-- Breadcrumbs 
    <div class="pl-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dash') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.membership.courses', ['page' => 1]) }}" @if($settings->spa_mode) wire:navigate @endif class="text-gray-400 hover:text-gray-100">{{ __('t.courses') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.course_details') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="grid lg:grid-cols-[1fr,400px] gap-6">
        {{-- Main Content --}}
        <div class="space-y-6">
            @if($purchased)
                <div class="bg-blue-400/10 text-blue-400 p-4 rounded-xl">
                    {{ __('t.you_have_already_purchased_this_course') }}
                </div>
            @endif

            <div class="bg-theme-secondary rounded-xl">
                <div class="p-6 space-y-6">
                    {{-- Course Title --}}
                    <h3 class="text-xl font-medium">{{ $data->title }}</h3>

                    {{-- Course Info --}}
                    <div class="grid md:grid-cols-3 gap-6">
                        <div>
                            <p class="text-theme-primary text-sm font-medium">{{ __('t.created_by') }}</p>
                            <p>{{ $settings->site_name }}</p>
                        </div>
                        <div>
                            <p class="text-theme-primary text-sm font-medium">{{ __('t.category') }}</p>
                            <p>{{ $data->category->name }}</p>
                        </div>
                        <div>
                            <p class="text-theme-primary text-sm font-medium">{{ __('t.last_updated') }}</p>
                            <p>{{ \Carbon\Carbon::parse($data->updated_at)->format('d M, Y') }}</p>
                        </div>
                    </div>

                    {{-- About Course --}}
                    <div>
                        <h4 class="text-lg font-medium mb-3">{{ __('t.about_course') }}</h4>
                        <p class="text-gray-300">{{ $data->description }}</p>
                    </div>

                    {{-- Course Lessons --}}
                    <div>
                        <h4 class="text-lg font-medium mb-4">{{ __('t.course_lessons') }}</h4>
                        <div class="space-y-4">
                            @forelse($data->lessons as $lesson)
                                <div>
                                    <div class="flex justify-between items-center">
                                        <div class="flex items-center gap-3">
                                            <i data-lucide="play-circle" class="w-8 h-8 text-red-400"></i>
                                            <div>
                                                <h6 class="font-medium">{{ $lesson->title }}</h6>
                                                <span class="text-sm text-gray-400">{{ $lesson->length }} {{ __('t.mins') }}</span>
                                            </div>
                                        </div>
                                        <div>
                                            @if($lesson->preview == 'true')
                                                <button 
                                                    data-modal-target="preview{{ $lesson->id }}"
                                                    class="inline-flex items-center gap-2 bg-blue-400/10 text-blue-400 px-3 py-1.5 rounded-lg hover:bg-blue-400/20 transition-colors">
                                                    <i data-lucide="unlock" class="w-4 h-4"></i>
                                                    {{ __('t.preview') }}
                                                </button>
                                            @else
                                                <i data-lucide="lock" class="w-5 h-5 text-gray-400"></i>
                                            @endif
                                        </div>
                                    </div>
                                    @if(!$loop->last)
                                        <div class="border-t border-gray-800 my-4"></div>
                                    @endif
                                </div>

                                @if($loop->iteration == 5)
                                    <div>
                                        <div class="flex items-center gap-2 text-gray-400">
                                            <span>{{ $loop->remaining }} {{ __('t.more_lessons', ['count' => $loop->remaining]) }}</span>
                                        </div>
                                    </div>
                                    @break
                                @endif

                                {{-- Preview Modal --}}
                                <div id="preview{{ $lesson->id }}" class="fixed inset-0 bg-black/50 z-50 hidden">
                                    <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-4xl">
                                        <div class="bg-theme-secondary rounded-xl overflow-hidden">
                                            <div class="aspect-w-16 aspect-h-9">
                                                @if(Str::startsWith($lesson->video_link, 'http'))
                                                    <iframe class="w-full h-full" src="{{ $lesson->video_link }}" allowfullscreen></iframe>
                                                @else
                                                    {!! $lesson->video_link !!}
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center py-8 text-gray-400">
                                    {{ __('t.no_data_available') }}
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Sidebar --}}
        <div class="bg-theme-secondary rounded-xl overflow-hidden">
            <img 
                src="{{ str_starts_with($data->image_url, 'http') ? $data->image_url : asset($data->image_url) }}"
                alt="{{ __('t.course_image') }}"
                class="w-full aspect-video object-cover">
            
            <div class="p-6">
                @if($purchased)
                    <a href="{{ route('user.membership.mycoursedetails', ['id' => $data->id]) }}"
                        @if($settings->spa_mode) wire:navigate @endif
                        class="block w-full bg-theme-primary text-black text-center font-medium px-4 py-3 rounded-lg hover:bg-theme-primary-dark transition-colors">
                        {{ __('t.watch_lesson') }}
                    </a>
                @else
                    <div class="space-y-4">
                        <h2 class="text-2xl font-medium">
                            {{ !$data->price ? __('t.free') : $settings->currency . number_format($data->price) }}
                        </h2>
                        <button 
                            data-modal-target="buyModal"
                            wire:loading.attr='disabled'
                            class="w-full bg-red-400 text-white font-medium px-4 py-3 rounded-lg hover:bg-red-500 transition-colors flex items-center justify-center gap-2">
                            <div wire:loading wire:target="buyCourse">
                                <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                            </div>
                            <span>{{ __('t.buy_now') }}</span>
                        </button>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Buy Modal --}}
    <div id="buyModal" class="fixed inset-0 bg-black/50 z-50 hidden">
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full max-w-md">
            <div class="bg-theme-secondary rounded-xl p-6">
                <p class="text-center mb-6">
                    
                    {{ __('t.deducted_from_balance', ['amount' => !$data->price ? $settings->currency . '0' : $settings->currency . number_format($data->price)]) }}
                </p>
                <div class="flex gap-3">
                    <button 
                        wire:click='buyCourse'
                        class="flex-1 bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors">
                        {{ __('t.purchase_now') }}
                    </button>
                    <button 
                        onclick="document.getElementById('buyModal').classList.add('hidden')"
                        class="flex-1 border border-gray-700 text-gray-300 px-4 py-2 rounded-lg hover:text-gray-100 transition-colors">
                        {{ __('t.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    lucide.createIcons();

    document.querySelectorAll('[data-modal-target]').forEach(button => {
        button.addEventListener('click', () => {
            const modalId = button.getAttribute('data-modal-target');
            document.getElementById(modalId).classList.remove('hidden');
        });
    });
</script>



