<div class="px-2 mt-2 space-y-8">
   {{-- 
    <div class="pl-3 flex items-center justify-between">
        <div>
            <div class="flex items-center text-sm text-gray-400">
                <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dash') }}</a>
                <i data-lucide="chevron-right" class="w-4 h-4 mx-2"></i>
                <span>{{ __('t.courses') }}</span>
            </div>
        </div>
    </div> --}}
     <x-danger-alert />
    <x-success-alert />

    {{-- Courses Grid --}}
    <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
        @forelse ($courses as $course)
            <div class="bg-theme-secondary rounded-2xl overflow-hidden group hover:shadow-lg hover:shadow-[#2563EB]/5 transition-all duration-300">
                <a href="{{ route('user.membership.course.details', [
                    'course' => str_replace(' ', '-', Str::lower($course->title)),
                    'id' => $course->id,
                ]) }}" @if ($settings->spa_mode) wire:navigate @endif>
                    <div class="relative">
                        <img 
                            src="{{ str_starts_with($course->image_url, 'https') ? $course->image_url : asset($course->image_url) }}"
                            alt="{{ $course->title }}"
                            class="w-full aspect-video object-cover group-hover:scale-105 transition-transform duration-300">
                        <div class="absolute inset-0 bg-gradient-to-t from-[#0F0A1F] to-transparent opacity-50"></div>
                    </div>
                </a>

                <div class="p-6">
                    <div class="flex justify-between items-start mb-4">
                        <h5 class="text-lg font-medium group-hover:text-theme-primary transition-colors">
                            {{ $course->title }}
                        </h5>
                        <div class="px-3 py-1 rounded-full text-xs font-medium {{ !$course->price ? 'bg-theme-primary/10 text-theme-primary' : 'bg-pink-400/10 text-pink-400' }}">
                            {{ !$course->price ? __('t.free') : $settings->currency . number_format(intval($course->price)) }}
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4 mb-6">
                        <div class="bg-theme-tertiary rounded-xl p-3">
                            <div class="flex items-center gap-2 text-sm">
                                <i data-lucide="book-open" class="w-4 h-4 text-theme-primary"></i>
                                <span class="text-gray-400">{{ $course->lessons_count }} {{ __('t.lessons') }}</span>
                            </div>
                        </div>
                        <div class="bg-theme-tertiary rounded-xl p-3">
                            <div class="flex items-center gap-2 text-sm">
                                <i data-lucide="users" class="w-4 h-4 text-theme-primary"></i>
                                <span class="text-gray-400">{{ $course->users_count }} {{ __('t.students') }}</span>
                            </div>
                        </div>
                    </div>

                    <a href="{{ route('user.membership.course.details', [
                        'course' => str_replace(' ', '-', Str::lower($course->title)),
                        'id' => $course->id,
                    ]) }}"
                        @if ($settings->spa_mode) wire:navigate @endif
                        class="flex items-center justify-between bg-theme-tertiary text-theme-primary p-4 rounded-xl group-hover:bg-theme-quaternary transition-colors">
                        <span>{{ __('t.view_details') }}</span>
                        <i data-lucide="arrow-right" class="w-5 h-5 group-hover:translate-x-1 transition-transform"></i>
                    </a>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <div class="bg-theme-secondary rounded-2xl p-12 text-center">
                    <div class="bg-theme-tertiary w-20 h-20 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="book-x" class="w-10 h-10 text-gray-400"></i>
                    </div>
                    <h3 class="text-xl font-medium mb-2">{{ __('t.no_courses') }}</h3>
                    <p class="text-gray-400">{{ __('t.check_later') }}</p>
                </div>
            </div>
        @endforelse
    </div>

    @include('components.pagination', ['route' => 'user.membership.courses'])

    {{-- Free Lessons Section --}}
    <div class="mt-12">
        <h3 class="text-2xl font-medium mb-6 flex items-center gap-3">
            <div class="bg-theme-primary/10 p-2 rounded-lg">
                <i data-lucide="gift" class="w-6 h-6 text-theme-primary"></i>
            </div>
            {{ __('t.free_lessons') }}
        </h3>
        
        <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
            @isset($lessons)
                @forelse ($lessons as $lesson)
                    <a href="{{ route('user.membership.learning', ['lesson' => $lesson->id]) }}"
                        @if ($settings->spa_mode) wire:navigate @endif
                        class="bg-theme-secondary rounded-xl overflow-hidden hover:bg-theme-tertiary transition-colors group">
                        <div class="p-4 flex gap-4">
                            <div class="w-28 flex-shrink-0">
                                <div class="relative aspect-video rounded-xl overflow-hidden">
                                    <img 
                                        src="{{ str_starts_with($lesson->thumbnail, 'http') ? $lesson->thumbnail : asset('storage/' . $lesson->thumbnail) }}"
                                        alt="{{ $lesson->title }}"
                                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                                    <div class="absolute inset-0 bg-black/20"></div>
                                    <div class="absolute inset-0 flex items-center justify-center">
                                        <div class="w-8 h-8 rounded-full bg-white/20 flex items-center justify-center">
                                            <i data-lucide="play" class="w-4 h-4 text-white"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <h5 class="font-medium mb-2 group-hover:text-theme-primary transition-colors">{{ $lesson->title }}</h5>
                                <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-theme-primary/10 text-theme-primary text-xs">
                                    {{ $lesson->category }}
                                </div>
                            </div>
                        </div>
                    </a>
                @empty
                    <div class="col-span-full">
                        <div class="bg-theme-secondary rounded-2xl p-12 text-center">
                            <h3 class="text-xl font-medium mb-2">{{ __('t.no_free_lessons') }}</h3>
                            <p class="text-gray-400">{{ __('t.free_coming_soon') }}</p>
                        </div>
                    </div>
                @endforelse
            @endisset
        </div>
    </div>
</div>



