<div class="space-y-6 px-2 mt-2">
    {{-- Breadcrumbs 
    <div class="pl-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dash') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <a href="{{ route('user.membership.mycourses') }}" @if($settings->spa_mode) wire:navigate @endif class="text-gray-400 hover:text-gray-100">
            {{ __('t.my_courses') }}
        </a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.course_details') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="bg-theme-secondary rounded-xl">
        <div class="p-6 space-y-6">
            {{-- Course Title --}}
            <div>
                <h2 class="text-2xl font-medium">{{ $data->title }}</h2>
            </div>

            {{-- Course Info --}}
            <div class="grid md:grid-cols-3 gap-6">
                <div>
                    <p class="text-theme-primary text-sm font-medium">{{ __('t.created_by') }}</p>
                    <p>{{ $settings->site_name }}</p>
                </div>
                <div>
                    <p class="text-theme-primary text-sm font-medium">{{ __('t.category') }}</p>
                    <p>{{ $data->category->name }}</p>
                </div>
                <div>
                    <p class="text-theme-primary text-sm font-medium">{{ __('t.purchased') }}</p>
                    <p>{{ \Carbon\Carbon::parse($data->created_at)->toDayDateTimeString() }}</p>
                </div>
            </div>

            {{-- Course Lessons --}}
            <div class="space-y-4">
                <h4 class="text-lg font-medium">{{ __('t.course_lessons') }}</h4>
                <div class="space-y-4">
                    @forelse($data->lessons as $lesson)
                        <div>
                            <div class="flex justify-between items-center">
                                <a href="{{ route('user.membership.learning', ['lesson' => $lesson->id, 'course' => $data->id]) }}"
                                    class="flex items-center gap-3 group"
                                    @if($settings->spa_mode) wire:navigate @endif>
                                    <i data-lucide="play-circle" class="w-8 h-8 text-red-400 group-hover:text-red-500 transition-colors"></i>
                                    <div>
                                        <h6 class="font-medium group-hover:text-theme-primary transition-colors">{{ $lesson->title }}</h6>
                                        <span class="text-sm text-gray-400">{{ $lesson->length }}</span>
                                    </div>
                                </a>
                                <a href="{{ route('user.membership.learning', ['lesson' => $lesson->id, 'course' => $data->id]) }}"
                                    @if($settings->spa_mode) wire:navigate @endif
                                    class="inline-flex items-center gap-2 bg-blue-400/10 text-blue-400 px-4 py-2 rounded-lg hover:bg-blue-400/20 transition-colors">
                                    <i data-lucide="play" class="w-4 h-4"></i>
                                    {{ __('t.watch') }}
                                </a>
                            </div>
                            @if(!$loop->last)
                                <div class="border-t border-gray-800 my-4"></div>
                            @endif
                        </div>
                    @empty
                        <div class="text-center py-8 text-gray-400">
                            <i data-lucide="inbox" class="w-12 h-12 mx-auto mb-4 opacity-50"></i>
                            <p>{{ __('t.no_lessons_available') }}</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    lucide.createIcons();
</script>



