@use('\Illuminate\Support\Str', 'Str')
<div class="space-y-6 mt-2">
    {{-- Breadcrumbs 
    <div class="pl-3 flex items-center text-sm flex-wrap gap-2">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dash') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400"></i>
        
        @if ($data)
            <a href="{{ route('user.membership.mycourses') }}" 
                @if ($settings->spa_mode) wire:navigate @endif 
                class="text-gray-400 hover:text-gray-100">
                {{ __('t.my_courses') }}
            </a>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400"></i>
            
            <a href="{{ route('user.membership.mycoursedetails', ['id' => $data->id]) }}"
                @if ($settings->spa_mode) wire:navigate @endif
                class="text-gray-400 hover:text-gray-100">
                {{ $data->title }}
            </a>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400"></i>
        @else
            <a href="{{ route('user.membership.courses', ['page' => 1]) }}"
                @if ($settings->spa_mode) wire:navigate @endif
                class="text-gray-400 hover:text-gray-100">
                {{ __('t.courses') }}
            </a>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400"></i>
        @endif
        
        <span class="text-gray-400">{{ $lesson['title'] }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="bg-theme-secondary rounded-xl">
        <div class="p-6 space-y-6" x-data="{ showDescription: true }">
            {{-- Description Toggle --}}
            <div class="flex items-center justify-between border-b border-gray-800 pb-4">
                <h4 class="text-lg font-medium">{{ __('t.description') }}</h4>
                <button @click.prevent="showDescription = !showDescription" 
                    class="flex items-center gap-2 text-gray-400 hover:text-gray-100 transition-colors">
                    <i data-lucide="eye" x-show="!showDescription" class="w-5 h-5"></i>
                    <i data-lucide="eye-off" x-show="showDescription" class="w-5 h-5"></i>
                </button>
            </div>

            {{-- Description Content --}}
            <div x-show="showDescription" 
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 transform -translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform -translate-y-2"
                class="prose prose-invert max-w-none">
                {!! $lesson['description'] !!}
            </div>

            {{-- Video Container --}}
            <div class="relative w-full" style="padding-top: 56.25%"> {{-- 16:9 Aspect Ratio --}}
                @if (Str::startsWith($lesson['video_link'], 'http'))
                    <iframe 
                        src="{{ $lesson['video_link'] }}"
                        class="absolute inset-0 w-full h-full rounded-lg"
                        allowfullscreen>
                    </iframe>
                @else
                    <div class="absolute inset-0 w-full h-full rounded-lg overflow-hidden">
                        {!! $lesson['video_link'] !!}
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
    lucide.createIcons();
</script>



