<div class="space-y-6 mb-5 md:mb-1">
  {{--  <div class="pl-3 pt-3 flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-gray-100">{{ __('t.dash') }}</a>
        <i data-lucide="chevron-right" class="w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.referral') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="bg-theme-secondary rounded-xl">
        <div class="p-6" x-data="{
            copied: false,
            url: '{{ auth()->user()->refferal_link }}',
            username: '{{ Auth::user()->username }}',
            showNotification(message, button) {
                const buttonPos = button.getBoundingClientRect();
                const scrollY = window.scrollY || window.pageYOffset;
                
                const notification = document.createElement('div');
                const top = buttonPos.top + scrollY;
                
                notification.innerHTML = `
                    <div class='fixed bg-theme-secondary border border-theme-primary/20 text-white px-3 py-2 rounded-lg shadow-lg transition-opacity duration-300 opacity-0 z-50 flex items-center gap-2'
                         style='top: ${top}px; left: ${buttonPos.right + 10}px'>
                        <svg xmlns='http://www.w3.org/2000/svg' class='h-4 w-4 text-theme-primary' fill='none' viewBox='0 0 24 24' stroke='currentColor'>
                            <path stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M5 13l4 4L19 7' />
                        </svg>
                        <span class='text-sm whitespace-nowrap'>${message}</span>
                    </div>
                `;

                document.body.appendChild(notification);
                
                requestAnimationFrame(() => {
                    notification.firstElementChild.classList.remove('opacity-0');
                    notification.firstElementChild.classList.add('opacity-100');
                });

                setTimeout(() => {
                    notification.firstElementChild.classList.remove('opacity-100');
                    notification.firstElementChild.classList.add('opacity-0');
                    setTimeout(() => notification.remove(), 300);
                }, 1500);
            },
            copyToClipboard(text, target) {
                if (!navigator.clipboard) {
                    return alert('{{ __('t.copy_error') }}');
                }
                
                navigator.clipboard.writeText(text)
                    .then(() => {
                        this.showNotification('{{ __('t.copied') }}', target);
                    });
            }
        }">
            <div class="max-w-2xl mx-auto space-y-8">
                {{-- Promotional Text --}}
                <div class="text-center bg-gradient-to-r from-[#2563EB]/10 to-[#0F0A1F] p-6 rounded-lg">
                    <h3 class="text-2xl font-semibold mb-2 bg-gradient-to-r from-[#2563EB] to-white bg-clip-text text-transparent">
                        {{ __('t.share_earn') }}
                    </h3>
                    <p class="text-gray-300">{{ __('t.invite_earn') }}</p>
                </div>

                {{-- Referral Link --}}
                <div class="text-center">
                    <h4 class="text-sm mb-4">{{ __('t.share_link') }}</h4>
                    <div class="flex relative">
                        <input type="text" 
                            value="{{ auth()->user()->refferal_link }}" 
                            readonly
                            class="flex-1 bg-gray-800/50 border border-r-0 border-gray-700 rounded-l-lg px-4 py-2.5 text-gray-300">
                        <button 
                            @click="copyToClipboard(url, $event.target.closest('button'))"
                            class="px-4 bg-theme-primary text-black border border-theme-primary rounded-r-lg hover:bg-theme-primary-dark transition-colors">
                            <i data-lucide="copy" class="w-5 h-5"></i>
                        </button>
                    </div>

                    {{-- Referral ID --}}
                    <div class="mt-6">
                        <h4 class="text-lg mb-2">{{ __('t.referral_id') }}</h4>
                        <div class="flex items-center justify-center gap-2 relative">
                            <span class="text-2xl text-theme-primary font-medium">{{ auth()->user()->username }}</span>
                            <button 
                                @click="copyToClipboard(username, $event.target.closest('button'))"
                                class="p-1 text-gray-400 hover:text-gray-300 transition-colors">
                                <i data-lucide="copy" class="w-5 h-5"></i>
                            </button>
                        </div>
                    </div>

                    {{-- Parent Info --}}
                    @if($parent)
                        <div class="mt-6 space-y-1">
                            <div class="flex items-center justify-center gap-2 text-gray-400">
                                <i data-lucide="user" class="w-5 h-5"></i>
                                <span>{{ __('t.parent') }}</span>
                            </div>
                            <h4 class="text-xl font-medium">{{ $parent->name }}</h4>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Referrals Table --}}
            <div class="mt-8 pt-8 border-t border-gray-800">
                <h4 class="text-lg font-medium mb-4">{{ __('t.your_referrals') }}</h4>
                <div class="relative overflow-x-auto rounded-lg border border-gray-800">
                    @if(trim(strip_tags($referrals)) != '')
                        <table class="w-full">
                            <thead>
                                <tr class="text-left text-sm text-gray-400 border-b border-gray-800 bg-gray-800/30">
                                    <th class="p-4 font-medium">{{ __('t.client_name') }}</th>
                                    <th class="p-4 font-medium">{{ __('t.ref_level') }}</th>
                                    <th class="p-4 font-medium">{{ __('t.parent') }}</th>
                                    <th class="p-4 font-medium">{{ __('t.client_status') }}</th>
                                    <th class="p-4 font-medium">{{ __('t.date_registered') }}</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-800">
                                {!! $referrals !!}
                            </tbody>
                        </table>
                    @else
                        <div class="flex flex-col items-center justify-center py-12 px-4 text-center">
                            <div class="bg-gray-800/30 p-4 rounded-full mb-4">
                                <i data-lucide="users" class="w-8 h-8 text-gray-400"></i>
                            </div>
                            <h3 class="text-lg font-medium mb-2">{{ __('t.no_referrals') }}</h3>
                            <p class="text-gray-400 max-w-sm">{{ __('t.share_invite') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>



