<div class="w-full p-2 mb-5 md:mb-1">
    {{-- Header 
    <div class="pl-3 flex items-center justify-between mb-8">
        <div class="flex items-center text-sm text-gray-400">
            <a href="{{ route('user.dashboard') }}" class="hover:text-theme-primary">{{ __('t.dashboard') }}</a>
            <i class="fas fa-chevron-right w-4 h-4 mx-2"></i>
            <span>{{ __('t.withdrawal') }}</span>
        </div>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="bg-theme-secondary rounded-2xl" x-data="{ showMethods: false }">
        @if(!$request)
            <div class="max-w-2xl mx-auto p-6">
                {{-- Heading --}}
                <div class="text-center mb-8">
                    <h2 class="text-2xl font-medium mb-2">{{ __('t.withdraw_funds') }}</h2>
                    <p class="text-gray-400">{{ __('t.select_withdrawal_method') }}</p>
                </div>

                {{-- Method Selection --}}
                <div class="mb-8 space-y-6 relative">
                    {{-- Custom Dropdown Trigger --}}
                    <button 
                        @click="showMethods = !showMethods"
                        class="w-full bg-theme-tertiary rounded-xl p-4 flex items-center justify-between hover:bg-theme-quaternary transition-colors relative"
                        x-bind:class="{ 'ring-2 ring-[#2563EB]': showMethods }"
                    >
                        @if($selectedMethod)
                            @php $selected = $methods->find($selectedMethod); @endphp
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 flex items-center justify-center bg-gray-800/50 rounded-lg">
                                    <img 
                                        src="{{ $selected->img_url ? $selected->img_url : asset('themes/purpose/img/Wallet.svg.png') }}"
                                        alt="{{ $selected->name }}"
                                        class="w-6 h-6 object-contain"
                                    >
                                </div>
                                <span class="font-medium">{{ $selected->name }}</span>
                            </div>
                        @else
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 flex items-center justify-center bg-gray-800/50 rounded-lg">
                                    <i class="fas fa-wallet text-gray-400 text-lg"></i>
                                </div>
                                <span class="text-gray-400">{{ __('t.choose_withdrawal_method') }}</span>
                            </div>
                        @endif
                        <i class="fas fa-chevron-down text-gray-400 transition-transform" x-bind:class="{ 'rotate-180': showMethods }"></i>
                    </button>

                    {{-- Methods Dropdown --}}
                    <div 
                        x-show="showMethods" 
                        @click.away="showMethods = false"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 translate-y-2"
                        class="absolute z-20 left-0 right-0 bg-theme-tertiary rounded-xl shadow-xl border border-gray-800/50 divide-y divide-gray-800/50"
                        style="display: none;"
                    >
                        @foreach($methods as $method)
                            <button 
                                wire:click="$set('selectedMethod', {{ $method->id }})"
                                @click="showMethods = false"
                                class="w-full p-4 flex items-center gap-4 hover:bg-theme-quaternary transition-colors"
                            >
                                <div class="w-10 h-10 flex items-center justify-center bg-gray-800/50 rounded-lg">
                                    <img 
                                        src="{{ $method->img_url ? $method->img_url : asset('themes/purpose/img/Wallet.svg.png') }}"
                                        alt="{{ $method->name }}"
                                        class="w-6 h-6 object-contain"
                                    >
                                </div>
                                <div class="flex-1 text-left">
                                    <p class="font-medium">{{ $method->name }}</p>
                                    <p class="text-sm text-gray-400">
                                        {{ __('t.min_text') }} {{ Number::currency($method->minimum, $settings->s_currency) }}
                                    </p>
                                </div>
                                @if($selectedMethod == $method->id)
                                    <div class="w-6 h-6 rounded-full bg-theme-primary/10 flex items-center justify-center">
                                        <i class="fas fa-check text-xs text-theme-primary"></i>
                                    </div>
                                @endif
                            </button>
                        @endforeach
                    </div>
                </div>
                
                <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '822714e37004aa7176f1b1efaaa4adf65c7f007b';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>


                {{-- Method Info Display --}}
                @if(!$selectedMethod)
                    <div class="bg-theme-tertiary rounded-xl p-6">
                        <div class="flex flex-col items-center text-center space-y-4">
                            <div class="w-16 h-16 flex items-center justify-center bg-theme-primary/10 rounded-full">
                                <i class="fas fa-wallet text-theme-primary text-2xl"></i>
                            </div>
                            <div class="max-w-md">
                                <h3 class="text-lg font-medium mb-2">{{ __('t.safe_secure_withdrawals') }}</h3>
                                <p class="text-gray-400 mb-6">{{ __('t.withdrawal_description') }}</p>
                            </div>
                            <div class="grid grid-cols-2 gap-4 w-full">
                                <div class="bg-theme-secondary rounded-xl p-4 flex flex-col items-center gap-2">
                                    <div class="w-12 h-12 flex items-center justify-center bg-theme-primary/10 rounded-full">
                                        <i class="fas fa-shield-alt text-theme-primary text-xl"></i>
                                    </div>
                                    <p class="text-sm text-gray-400">{{ __('t.secure_processing') }}</p>
                                </div>
                                <div class="bg-theme-secondary rounded-xl p-4 flex flex-col items-center gap-2">
                                    <div class="w-12 h-12 flex items-center justify-center bg-theme-primary/10 rounded-full">
                                        <i class="fas fa-clock text-theme-primary text-xl"></i>
                                    </div>
                                    <p class="text-sm text-gray-400">{{ __('t.fast_withdrawals') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Selected Method Details --}}
                @if($selectedMethod)
                    @php $method = $methods->find($selectedMethod); @endphp
                    <div class="space-y-6">
                        {{-- Method Info Cards --}}
                        <div class="grid grid-cols-2 sm:grid-cols-3 gap-4">
                            <div class="bg-theme-tertiary p-4 rounded-xl">
                                <p class="text-sm text-gray-400 mb-2">{{ __('t.min_withdrawal') }}</p>
                                <p class="font-medium text-theme-primary">
                                    {{ Number::currency($method->minimum, $settings->s_currency) }}
                                </p>
                            </div>
                            <div class="bg-theme-tertiary p-4 rounded-xl">
                                <p class="text-sm text-gray-400 mb-2">{{ __('t.max_withdrawal') }}</p>
                                <p class="font-medium text-theme-primary">
                                    {{ Number::currency($method->maximum, $settings->s_currency) }}
                                </p>
                            </div>
                            <div class="bg-theme-tertiary p-4 rounded-xl sm:col-span-1 col-span-2">
                                <p class="text-sm text-gray-400 mb-2">{{ __('t.processing_fee') }}</p>
                                <p class="font-medium text-theme-primary">
                                    @if($method->charges_type == 'percentage')
                                        {{ Number::percentage($method->charges_amount) }}
                                    @else
                                        {{ Number::currency($method->charges_amount, $settings->s_currency) }}
                                    @endif
                                </p>
                            </div>
                        </div>

                        {{-- Continue Button --}}
                        <button 
                            wire:click="requestWithdrawal({{ $method->id }})"
                            class="w-full bg-gradient-theme-primary text-black font-medium px-6 py-4 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-3">
                            <div wire:loading wire:target="requestWithdrawal({{ $method->id }})">
                                <i class="fas fa-spinner fa-spin"></i>
                            </div>
                            <span wire:loading.remove wire:target="requestWithdrawal({{ $method->id }})">
                                {{ __('t.continue_with') }} {{ $method->name }}
                            </span>
                            <i class="fas fa-arrow-right" wire:loading.remove wire:target="requestWithdrawal({{ $method->id }})"></i>
                        </button>
                    </div>
                @endif
            </div>
        @else
            {{-- Cancel Button --}}
            <div class="p-6 border-b border-gray-800/50">
                <div class="flex justify-between items-center">
                    <h3 class="font-medium">{{ __('t.complete_withdrawal') }}</h3>
                    <button 
                        wire:click="$set('request', false)"
                        class="inline-flex items-center gap-2 px-4 py-2 bg-red-500/10 text-red-500 rounded-lg hover:bg-red-500/20 transition-colors">
                        <i class="fas fa-times"></i>
                        {{ __('t.cancel_request') }}
                    </button>
                </div>
            </div>

            {{-- Withdrawal Form --}}
            <div class="p-6">
                <livewire:user.withdrawal.complete-withdrawal :method="$method" />
            </div>
        @endif
    </div>
</div>



