<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
 <?php $__env->slot('title', null, []); ?> 
        Pending Trades
     <?php $__env->endSlot(); ?>
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <h4 class="card-title">Pending Trades</h4>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Pair</th>
                                    <th>Amount</th>
                                    <th>Type</th>
                                    <th>Entry Price</th>
                                    <th>Duration</th>
                                    <th>Expected Result</th>
                                    <th>Profit Amount</th>
                                    <th>Started At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($trade->user->name); ?></td>
                                        <td><?php echo e($trade->pair); ?></td>
                                        <td><?php echo e(number_format($trade->amount, 2)); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo e($trade->type == 'Rise' ? 'success' : 'danger'); ?>">
                                                <?php echo e($trade->type); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($trade->entry_price); ?></td>
                                        <td><?php echo e($trade->duration); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo e($trade->expected_result == 'win' ? 'success' : 'danger'); ?>">
                                                <?php echo e(ucfirst($trade->expected_result)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <span class="text-<?php echo e($trade->profit_amount >= 0 ? 'success' : 'danger'); ?>">
                                                <?php echo e(number_format($trade->profit_amount, 2)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($trade->created_at->format('d M, Y H:i')); ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" 
                                                        class="btn btn-sm btn-info" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#tradeModal-<?php echo e($trade->id); ?>">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <button type="button" 
                                                        class="btn btn-sm btn-primary" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#editModal-<?php echo e($trade->id); ?>">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editModal-<?php echo e($trade->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="<?php echo e(route('admin.trading.update', $trade)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Edit Trade Result</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="expected_result" class="form-label">Expected Result</label>
                                                            <select name="expected_result" id="expected_result" class="form-select">
                                                                <option value="win" <?php echo e($trade->expected_result == 'win' ? 'selected' : ''); ?>>Win</option>
                                                                <option value="loss" <?php echo e($trade->expected_result == 'loss' ? 'selected' : ''); ?>>Loss</option>
                                                            </select>
                                                            <?php $__errorArgs = ['expected_result'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="text-danger small"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="profit_amount" class="form-label">Profit Amount</label>
                                                            <div class="input-group">
                                                                <input type="number" 
                                                                       name="profit_amount" 
                                                                       id="profit_amount" 
                                                                       class="form-control" 
                                                                       value="<?php echo e(abs($trade->profit_amount)); ?>"
                                                                       step="0.01"
                                                                       min="0">
                                                            </div>
                                                            <small class="text-muted">
                                                                Current: 
                                                                <span class="text-<?php echo e($trade->profit_amount >= 0 ? 'success' : 'danger'); ?>">
                                                                    <?php echo e(number_format($trade->profit_amount, 2)); ?>

                                                                </span>
                                                            </small>
                                                            <?php $__errorArgs = ['profit_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="text-danger small"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- View Details Modal -->
                                    <div class="modal fade" id="tradeModal-<?php echo e($trade->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Trade Details</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>User:</strong></div>
                                                        <div class="col-6"><?php echo e($trade->user->name); ?></div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Pair:</strong></div>
                                                        <div class="col-6"><?php echo e($trade->pair); ?></div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Amount:</strong></div>
                                                        <div class="col-6"><?php echo e(number_format($trade->amount, 2)); ?></div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Type:</strong></div>
                                                        <div class="col-6">
                                                            <span class="badge bg-<?php echo e($trade->type == 'Rise' ? 'success' : 'danger'); ?>">
                                                                <?php echo e($trade->type); ?>

                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Entry Price:</strong></div>
                                                        <div class="col-6"><?php echo e($trade->entry_price); ?></div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Duration:</strong></div>
                                                        <div class="col-6"><?php echo e($trade->duration); ?></div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Expected Result:</strong></div>
                                                        <div class="col-6">
                                                            <span class="badge bg-<?php echo e($trade->expected_result == 'win' ? 'success' : 'danger'); ?>">
                                                                <?php echo e(ucfirst($trade->expected_result)); ?>

                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-2">
                                                        <div class="col-6"><strong>Profit Amount:</strong></div>
                                                        <div class="col-6">
                                                            <span class="text-<?php echo e($trade->profit_amount >= 0 ? 'success' : 'danger'); ?>">
                                                                <?php echo e(number_format($trade->profit_amount, 2)); ?>

                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="10" class="text-center">No pending trades found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        <?php echo e($trades->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
                    <script>
document.addEventListener('DOMContentLoaded', function() {
    // Get all edit buttons
    const editButtons = document.querySelectorAll('[data-bs-toggle="modal"]');
    
    editButtons.forEach(button => {
        button.addEventListener('click', () => {
            const modalId = button.getAttribute('data-bs-target');
            const modal = document.querySelector(modalId);
            if (modal) {
                modal.style.display = 'block';
                modal.classList.add('show');
                document.body.classList.add('modal-open');
                
                // Add backdrop
                const backdrop = document.createElement('div');
                backdrop.className = 'modal-backdrop fade show';
                document.body.appendChild(backdrop);
            }
        });
    });

    // Handle close buttons
    const closeButtons = document.querySelectorAll('[data-bs-dismiss="modal"]');
    closeButtons.forEach(button => {
        button.addEventListener('click', () => {
            const modal = button.closest('.modal');
            if (modal) {
                modal.style.display = 'none';
                modal.classList.remove('show');
                document.body.classList.remove('modal-open');
                
                // Remove backdrop
                const backdrop = document.querySelector('.modal-backdrop');
                if (backdrop) {
                    backdrop.remove();
                }
            }
        });
    });
});
</script>
<style>
.modal {
    background-color: rgba(0,0,0,0.5);
}
.modal.show {
    display: block;
}
</style>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>




<?php /**PATH C:\xampp\htdocs\6figs\resources\views/admin/trading/pending.blade.php ENDPATH**/ ?>