<div class="flex justify-center mb-6">
    <div x-data="{ open: false }" class="relative">
        <button @click="open = !open" 
                @click.outside="open = false"
                class="flex items-center gap-2 bg-gray-800/50 hover:bg-gray-800 text-gray-300 px-3 py-2 rounded-lg transition-colors">
            <?php
                $flags = [
                    'en' => '🇺🇸',
                    'es' => '🇪🇸',
                    'fr' => '🇫🇷',
                    'de' => '🇩🇪',
                    'ar' => '🇸🇦',
                    'pt' => '🇵🇹',
                    'fa' => '🇮🇷',
                    'zh' => '🇨🇳',
                    'hi' => '🇮🇳',
                    'ru' => '🇷🇺'
                ];
                $names = [
                    'en' => 'English',
                    'es' => 'Español',
                    'fr' => 'Français',
                    'de' => 'Deutsch',
                    'ar' => 'العربية',
                    'pt' => 'Português',
                    'fa' => 'فارسی',
                    'zh' => '中文',
                    'hi' => 'हिन्दी',
                    'ru' => 'Русский'
                ];
                $currentLocale = app()->getLocale();
            ?>
            <span><?php echo e($flags[$currentLocale] ?? '🌐'); ?></span>
            <span><?php echo e($names[$currentLocale] ?? 'Language'); ?></span>
            <i data-lucide="chevron-down" 
               class="w-4 h-4" 
               :class="{ 'rotate-180': open }"></i>
        </button>

        <div x-show="open"
             x-transition:enter="transition ease-out duration-100"
             x-transition:enter-start="opacity-0 scale-95"
             x-transition:enter-end="opacity-100 scale-100"
             x-transition:leave="transition ease-in duration-75"
             x-transition:leave-start="opacity-100 scale-100"
             x-transition:leave-end="opacity-0 scale-95"
             class="absolute top-full mt-2 right-0 bg-gray-800 rounded-lg shadow-lg overflow-hidden min-w-[160px] z-50"
             style="display: none;">
            
            <div class="py-1">
                <?php $__currentLoopData = $flags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale => $flag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('language.switch', $locale)); ?>" 
                       class="flex items-center gap-2 px-4 py-2 text-sm <?php echo e($currentLocale === $locale ? 'bg-theme-primary/10 text-theme-primary' : 'text-gray-300 hover:bg-gray-700'); ?>">
                        <span><?php echo e($flag); ?></span>
                        <span><?php echo e($names[$locale]); ?></span>
                        <?php if($currentLocale === $locale): ?>
                            <i data-lucide="check" class="w-4 h-4 ml-auto"></i>
                        <?php endif; ?>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<script>
    // Make sure Lucide icons are created after Alpine.js initializes
    document.addEventListener('alpine:init', () => {
        lucide.createIcons();
    });

    // RTL Support
   // const rtlLocales = ['ar', 'fa'];
   // const currentLocale = '<?php echo e(app()->getLocale()); ?>';

   // if (rtlLocales.includes(currentLocale)) {
   //     document.documentElement.setAttribute('dir', 'rtl');
     //   document.documentElement.style.direction = 'rtl';
   // } else {
  //      document.documentElement.setAttribute('dir', 'ltr');
   //     document.documentElement.style.direction = 'ltr';
  //  }
</script>





<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/components/language-switcher.blade.php ENDPATH**/ ?>