<form wire:submit='saveProfile' class="space-y-6">
    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.username')); ?></label>
        <input type="text" 
            wire:model='username'
            readonly
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 text-gray-400">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.fullname')); ?></label>
        <input type="text" 
            wire:model='name'
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.phone_number')); ?></label>
        <input type="tel" 
            wire:model='phone_number'
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 focus:outline-none focus:border-[#1D4ED8]">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.email_address')); ?></label>
        <input type="email" 
            wire:model='email'
            readonly
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 text-gray-400">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.country')); ?></label>
        <input type="text" 
            wire:model='country'
            readonly
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 text-gray-400">
    </div>

    
    <div class="space-y-2">
        <label class="text-sm text-gray-400"><?php echo e(__('t.address')); ?></label>
        <input type="text" 
            wire:model='address'
            readonly
            class="w-full bg-gray-800/50 border border-gray-700 rounded-lg px-4 py-2.5 text-gray-400">
    </div>

    
    <div class="flex justify-end">
        <button type="submit"
            class="bg-theme-primary text-black px-6 py-2.5 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center gap-2">
            <i data-lucide="save" class="w-5 h-5" wire:loading.remove wire:target="saveProfile"></i>
            <div wire:loading wire:target="saveProfile">
                <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
            </div>
            <span><?php echo e(__('t.save')); ?></span>
        </button>
    </div>
</form>



<?php /**PATH /home/ooqnzyma/diversifymarkets.com/resources/views/millage/account-settings/profile.blade.php ENDPATH**/ ?>