<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset($settings->favicon)); ?>" />
    <title><?php echo e($settings->site_name); ?> - <?php echo e($title); ?></title>
    <meta name="description" content="<?php echo e($settings->description); ?>" />
    <meta name="keywords" content="<?php echo e($settings->keywords); ?>" />

    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" /> <!--end::Fonts-->

    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="<?php echo e(asset('themes/default/plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    
    <!--end::Global Stylesheets Bundle-->
    <?php echo $__env->make('layouts.includes.auth-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Styles -->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>

<body id="kt_body" class="app-blank">
    <!--begin::Root-->
    <section style="height: 100vh; background:#e1f0f8">
        <div class="d-flex flex-column flex-root" id="kt_app_root">
            <!--begin::Authentication - Sign-in -->
            <div class="d-flex flex-column flex-lg-row flex-column-fluid">
                <!--begin::Body-->
                <div class=" d-flex flex-column flex-lg-row-fluid w-lg-50">
                    <!--begin::Form-->
                    <div class="p-3 d-flex flex-center flex-column flex-lg-row-fluid p-lg-0">
                        <!--begin::Wrapper-->
                        <div class="p-5 rounded shadow-sm p-lg-10 w-lg-500px" style="margin-top: 100px;">
                            <div class="mb-8 text-center">
                                <!--begin::Logo-->
                                <a href="/" class="mb-0 text-center mb-lg-20">
                                    <img alt="Logo" src="<?php echo e(asset($settings->logo)); ?>"
                                        width="<?php echo e($settings->auth_pages_logo_size); ?>" />
                                </a>
                                <!--end::Logo-->
                            </div>
                            <?php echo e($slot); ?>

                        </div>
                        <!--end::Wrapper-->
                    </div>
                    <!--end::Form-->
                </div>
                <!--end::Body-->
            </div>
            <!--end::Authentication -->
        </div>
    </section>
    <!--end::Root-->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script src="<?php echo e(asset('themes/default/plugins/global/plugins.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('themes/default/js/scripts.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('themes/default/js/custom/authentication/sign-in/general.js')); ?>"></script>
</body>

</html>





<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/components/layouts/app.blade.php ENDPATH**/ ?>