<header class="w-full flex items-center justify-between p-4 bg-theme-secondary border-b border-gray-800/50">
    
    <div class="flex items-center gap-4">
        <img src="<?php echo e(asset($settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-8">
    </div>

    
    <div class="flex items-center gap-2">
        
<div class="relative" id="languageDropdown">
    <button class="flex items-center gap-2 bg-theme-tertiary rounded-xl px-3 py-2 text-sm text-gray-400 hover:text-gray-300 transition-colors">
        <?php
            $currentLocale = app()->getLocale();
            $flags = [
                'en' => '&#x1F1FA;&#x1F1F8;', 
                'es' => '&#x1F1EA;&#x1F1F8;', 
                'fr' => '&#x1F1EB;&#x1F1F7;', 
                'de' => '&#x1F1E9;&#x1F1EA;', 
                'ar' => '&#x1F1F8;&#x1F1E6;', 
                'pt' => '&#x1F1F5;&#x1F1F9;', 
                'fa' => '&#x1F1EE;&#x1F1F7;', 
                'zh' => '&#x1F1E8;&#x1F1F3;',
                'hi' => '&#x1F1EE;&#x1F1F3;',
                'ru' => '&#x1F1F7;&#x1F1FA;' 
            ];
        ?>
        <span class="mr-1"><?php echo $flags[$currentLocale] ?? $flags['en']; ?></span>
        <?php echo e(strtoupper($currentLocale)); ?>

        <i class="fas fa-chevron-down w-4 h-4"></i>
    </button>
    <div id="languageMenu" 
        class="absolute right-0 mt-2 w-48 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
        <?php $__currentLoopData = config('app.available_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('language.switch', $locale)); ?>" 
                class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:bg-theme-quaternary hover:text-gray-300 transition-colors">
                <span><?php echo $flags[$locale] ?? $flags['en']; ?></span>
                <?php echo e($name); ?>

            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

        
        <div class="relative" id="reportsDropdown">
            <button class="p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-theme-tertiary">
                <i class="fas fa-file-alt w-5 h-5"></i>
            </button>
            <div id="reportsMenu" 
                class="absolute right-0 mt-2 w-64 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4">
                    <h3 class="text-sm font-medium text-gray-300 mb-2"><?php echo e(__('t.annual_r')); ?></h3>
                    <div class="space-y-1">
                        <?php $__empty_1 = true; $__currentLoopData = \App\Models\AnnualReport::where('is_active', true)->orderBy('report_year', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(Storage::url($report->file_path)); ?>" 
                                target="_blank"
                                class="flex items-center gap-3 px-3 py-2 text-sm text-gray-400 hover:text-gray-300 hover:bg-theme-quaternary rounded-lg transition-colors">
                                <i class="fas fa-download w-4 h-4"></i>
                                <?php echo e($report->name); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-sm text-gray-400 px-3 py-2"><?php echo e(__('t.no_reports')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="relative" id="notificationDropdown">
            <button class="relative p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-theme-tertiary">
                <i class="fas fa-bell w-5 h-5"></i>
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('user.notifications-count', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1965769109-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </button>
            <div id="notificationMenu" 
                class="absolute right-0 mt-2 w-80 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4">
                    <div class="space-y-4">
                        <?php $__empty_1 = true; $__currentLoopData = auth()->user()->notifications()->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="flex items-start gap-3 pb-4 border-b border-gray-800/50 last:border-0 last:pb-0">
                                
                                <div class="w-8 h-8 flex-shrink-0 bg-theme-primary/10 rounded-xl flex items-center justify-center">
                                    <?php switch($notification->data['type'] ?? 'default'):
                                        case ('deposit'): ?>
                                            <i class="fas fa-arrow-down text-theme-primary w-4 h-4"></i>
                                            <?php break; ?>
                                        <?php case ('withdrawal'): ?>
                                            <i class="fas fa-arrow-up text-theme-primary w-4 h-4"></i>
                                            <?php break; ?>
                                        <?php case ('investment'): ?>
                                            <i class="fas fa-chart-line text-theme-primary w-4 h-4"></i>
                                            <?php break; ?>
                                        <?php case ('roi'): ?>
                                            <i class="fas fa-piggy-bank text-theme-primary w-4 h-4"></i>
                                            <?php break; ?>
                                        <?php default: ?>
                                            <i class="fas fa-bell text-theme-primary w-4 h-4"></i>
                                    <?php endswitch; ?>
                                </div>
                                
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm text-gray-300"><?php echo e($notification->data['message']); ?></p>
                                    <span class="text-xs text-gray-500"><?php echo e($notification->created_at->diffForHumans()); ?></span>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center py-6">
                                <div class="w-12 h-12 mx-auto mb-3 bg-gray-800/50 rounded-xl flex items-center justify-center">
                                    <i class="fas fa-bell-slash text-gray-400 w-6 h-6"></i>
                                </div>
                                <p class="text-sm text-gray-400"><?php echo e(__('t.no_notify')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    
                    <?php if(auth()->user()->notifications()->count() > 0): ?>
                        <div class="mt-4 pt-4 border-t border-gray-800/50">
                            <a href="<?php echo e(route('user.notifications')); ?>" 
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                                class="block w-full bg-theme-tertiary text-theme-primary text-center text-sm font-medium px-4 py-2.5 rounded-xl hover:bg-theme-quaternary transition-colors">
                                <?php echo e(__('t.view_notify')); ?>

                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="relative" id="userDropdown">
            <button class="p-2 text-gray-400 hover:text-gray-300 transition-colors rounded-xl hover:bg-theme-tertiary">
                <i class="fas fa-user w-5 h-5"></i>
            </button>
            <div id="userMenu" 
                class="absolute right-0 mt-2 w-64 bg-theme-tertiary rounded-xl border border-gray-800/50 shadow-xl overflow-hidden hidden z-50">
                <div class="p-4 border-b border-gray-800/50">
                    <h3 class="font-medium truncate"><?php echo e(auth()->user()->name); ?></h3>
                    <p class="text-sm text-gray-400 truncate"><?php echo e(auth()->user()->email); ?></p>
                </div>
                
                
                <?php if($settings->enable_kyc): ?>
                <div class="p-4 border-b border-gray-800/50 bg-theme-quaternary/50">
                    <div class="flex items-center justify-between gap-2">
                        <span class="text-sm text-gray-400"><?php echo e(__('t.acc_status')); ?></span>
                        <?php if(Auth::user()->account_verify == 'verified'): ?>
                            <span class="text-xs font-medium px-2 py-1 bg-theme-primary/10 text-theme-primary rounded-lg"><?php echo e(__('t.verify')); ?></span>
                        <?php else: ?>
                            <a href="<?php echo e(route('user.kyc.start')); ?>"
                                <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?> 
                                class="text-xs font-medium px-2 py-1 bg-theme-primary/10 text-theme-primary rounded-lg hover:bg-theme-primary/20 transition-colors">
                                <?php echo e(__('t.verify_now')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <div class="p-2">
                    <a href="<?php echo e(route('user.profile.show')); ?>" 
                        <?php if($settings->spa_mode): ?> wire:navigate <?php endif; ?>
                        class="flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-theme-quaternary transition-colors">
                        <i class="fas fa-cog w-4 h-4"></i>
                        <?php echo e(__('t.set')); ?>

                    </a>
                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" 
                            class="w-full flex items-center gap-3 px-4 py-2.5 text-sm text-gray-400 hover:text-gray-300 rounded-lg hover:bg-theme-quaternary transition-colors">
                            <i class="fas fa-sign-out-alt w-4 h-4"></i>
                            <?php echo e(__('t.logout')); ?>

                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
    // Dropdown toggles
    function setupDropdown(triggerId, menuId) {
        const trigger = document.getElementById(triggerId);
        const menu = document.getElementById(menuId);
        
        if (trigger && menu) {
            trigger.addEventListener('click', (e) => {
                e.stopPropagation();
                menu.classList.toggle('hidden');
            });

            document.addEventListener('click', () => {
                menu.classList.add('hidden');
            });
        }
    }

    // Setup all dropdowns
    document.addEventListener('DOMContentLoaded', function() {
        setupDropdown('reportsDropdown', 'reportsMenu');
    });
    
</script>





<?php /**PATH /home/ooqnzyma/diversifymarkets.com/resources/views/layouts/includes/header.blade.php ENDPATH**/ ?>